/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.cheEmblem;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class cheOkeData {
    public static final int datasize = 7872;
    static final ArrayList<String> bodylist;
    int okeno;
    byte[] realData;
    cheEmblem emblem;

    public cheOkeData(int n) {
        this.okeno = n;
        this.realData = new byte[7872];
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getName().equals(this.getClass().getName())) {
            return Arrays.equals(((cheOkeData)obj).realData, this.realData);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Arrays.hashCode(this.realData);
        return hash;
    }

    public void copy(cheOkeData p) {
        System.arraycopy(this.realData, 0, p.realData, 0, 7872);
        p.emblem = this.emblem;
    }

    public boolean load(byte[] s, int nofs) {
        if (nofs + 7872 > s.length) {
            return false;
        }
        for (int i = 0; i < 7872; ++i) {
            this.realData[i] = s[i + nofs];
        }
        this.emblem = new cheEmblem(this.realData, 48);
        return true;
    }

    public boolean save(byte[] s, int nofs) {
        if (nofs + 7872 > s.length) {
            return false;
        }
        for (int i = 0; i < 7872; ++i) {
            s[i + nofs] = this.realData[i];
        }
        return true;
    }

    public int get_flag() {
        int n = this.realData[0] & 0xFF;
        n |= (this.realData[1] & 0xFF) << 8;
        n |= (this.realData[2] & 0xFF) << 16;
        return n |= (this.realData[3] & 0xFF) << 24;
    }

    public String get_name() {
        int nlen;
        byte[] work = new byte[28];
        for (nlen = 0; nlen < 28; ++nlen) {
            work[nlen] = this.realData[4 + nlen];
            if (work[nlen] == 0) break;
        }
        try {
            return new String(work, 0, nlen, "SJIS");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(cheOkeData.class.getName()).log(Level.SEVERE, null, ex);
            return new String();
        }
    }

    public cheEmblem get_emblem() {
        return this.emblem;
    }

    public int get_no() {
        return this.okeno;
    }

    public String get_bodyname() {
        return bodylist.get(this.realData[624]);
    }

    public String toString() {
        String retstr = this.get_name();
        for (int i = retstr.length(); i < 14; ++i) {
            retstr = retstr + "\u3000";
        }
        retstr = retstr + "(";
        try {
            retstr = retstr + this.get_bodyname();
        }
        catch (IndexOutOfBoundsException e) {
            retstr = retstr + "?";
        }
        retstr = retstr + ")";
        return retstr;
    }

    public void dump(String basename) {
        String filename = basename + "-" + this.okeno + ".bin";
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(this.realData);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(cheOkeData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(cheOkeData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        int nbody;
        bodylist = new ArrayList();
        try {
            String bodys = ResourceBundle.getBundle("chexaformation/resource").getString("okeBodyList");
            Scanner data = new Scanner(bodys).useDelimiter(",");
            while (data.hasNext()) {
                bodylist.add(data.next());
                ++nbody;
            }
            data.close();
        }
        catch (NoSuchElementException ex) {
            for (nbody = 0; nbody < 38; ++nbody) {
                bodylist.add(String.format("%02x", nbody));
            }
        }
        catch (Exception ex) {
            bodylist.clear();
            for (nbody = 0; nbody < 38; ++nbody) {
                bodylist.add(String.format("%02x", nbody));
            }
            Logger.getLogger(cheOkeData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

