/**
 *
 */
package myUtil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * @author Kayano
 *
 */
public class Inputclass {

	public static String getString(String title) {
		System.out.println(title);
		return getString();
	}

	public static int getNumber(String title) {
		System.out.println(title);
		return getNumber();
	}

	/**.
	 * 標準入力から、文字列を取得して、数字へ変換します。
	 * 入力文字列が０以上の数値でない場合は-1を返却します。
	 *
	 * @return 番号
	 */
	private static int getNumber() {
		String inputNumberstr = null;
		int number = -1;

		inputNumberstr = getString();

		//入力された文字列をint型へ変換します。
		try {
			number = Integer.parseInt(inputNumberstr);
			if (number < 0) {
				number = -1;
			}

		} catch (NumberFormatException numberFormatException) {
			number = -1;

		} catch (Exception e) {
			number = -1;
		}
		return number;
	}

	/**.
	 * 標準入力より、文字列を取得し返却するメソッド
	 *
	 * @return 文字列の返却
	 */
	private static String getString() {
		BufferedReader bufferedReader = null;
		String inputString = null;

		try {
			//標準入力より文字列を取得して、変数へ格納します。
			do {
				bufferedReader = new BufferedReader(new InputStreamReader(System.in));
				inputString = bufferedReader.readLine();
			} while (inputString == null || inputString.length() == 0);
		} catch (IOException ioException) {
			ioException.printStackTrace();
			System.exit(0);
		}
		return inputString;
	}

}
