/**
 *
 */
package myUtil;

import java.io.File;

/**
 * @author Kayano
 *
 */
public class ArgsUtil {

	/**
	 * メニュー番号を選択すると、該当するファイルを返却します。
	 *
	 * @param fileName ファイル名
	 * @return 該当ファイル
	 */
	public static String parseArgs(String[] fileName) {
		//複数のファイルが存在しています
		System.out.println(fileName.length + "のファイルが存在しています");
		for (String str : fileName) {
			System.out.println(str);
		}

		//ファイルが何も指定されていないとき
		if (fileName.length == 0) {
			System.err.println("ファイルが何も指定されていません。");
			System.exit(0);
		}

		//ファイルを読み込むための準備
		File file1 = new File(fileName[1]);
		File file2 = new File(fileName[2]);
		File file3 = new File(fileName[3]);

		//メニュー選択で、指定された番号が選択された場合、
		// 指定されたファイルが存在しているかを確認します。

		if (file1.exists() == false) {
			System.err.println(fileName[1] + "not exist");
		}
		if (file2.exists() == false) {
			System.err.println(fileName[2] + "not exist");
		}
		if (file3.exists() == false) {
			System.err.println(fileName[3] + "not exist");
		}

		//条件に応じてファイルを返します。
		return fileName[1];
	}

	/**
	 * 複数のファイルが存在し、該当ファイルを返したい場合は、
	 * こちらのメソッドで、取得された番号から得られたfileName[i]を引数として
	 * ファイル名を返します。
	 *
	 * @param fileName
	 * @return
	 */
	public static String parseArgs(String fileName) {
		return fileName;
	}

}
