/**
 *
 */
package dao;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import vofiles.ResultVO;

/**
 * このクラスではデータアクセスオブジェクトとして接続を管理します。
 *
 * @author Kayano
 *
 */
public class ResultDao {

	private static final String DELIMITER = "\t";
	private String fileName;

	/**
	 * コンストラクタ
	 *
	 * @param fileName ファイル名
	 */
	public ResultDao(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * Member.txtから、部員情報を1行ごとに読み込み全表示し、listを返却します。
	 *
	 * @param fileName Member.txt
	 * @return list 部員情報
	 */
	public List<ResultVO> getAllmulti() {

		//クラスオブジェクトを作成
		List<ResultVO> list = new ArrayList<ResultVO>();

		//ファイルを開き、読み込みます
		try (BufferedReader bufferedReader = new BufferedReader(new FileReader("src/" + fileName))) {

			//ファイルの１行を読み込みがnullでなくなるまで繰り返す。
			String OneRecord = null;
			ResultVO resultVO = null;

			while ((OneRecord = bufferedReader.readLine()) != null) {

				//\tで分割を行い、配列に格納します。arrays[0]---arrrays[]まで。
				String[] arrays = OneRecord.split(DELIMITER);

				//EmpVOmemberから部員情報を取得します。
				resultVO = new ResultVO();

				resultVO.setYear(arrays[0]);
				resultVO.setMonth(arrays[1]);
				resultVO.setDay(arrays[2]);
				resultVO.setStartTime(arrays[3]);
				resultVO.setEndTime(arrays[4]);
				resultVO.setContents(arrays[5]);
				resultVO.setResult(arrays[6]);
				resultVO.setFlag(arrays[7]);
				resultVO.setOthers(arrays[8]);

				list.add(resultVO);
			}
			//ファイルが開けないときの例外処理
		} catch (FileNotFoundException fileNotFoundException) {
			System.err.println("ファイルが開けません");
			fileNotFoundException.printStackTrace();

			//ファイルが空文字の場合の例外処理
		} catch (NullPointerException nullPointerException) {
			System.out.println("ファイル名が空文字です。");
			nullPointerException.printStackTrace();

			//ファイルデータを読み出せないときの例外処理
		} catch (IOException ioException) {
			System.out.println("データを読み出せません。");
			ioException.printStackTrace();
		}
		return list;
	}

	/**
	 * 単一検索機能（指定された部員の情報を検索します）
	 *
	 * @param fileName1 ファイル名
	 * @return
	 */
	public ResultVO getMono(String Year, String Month, String Day, String StartTime, String EndTime) {

		//クラスオブジェクトを作成しません！！
		//List<String> list = new ArrayList<String>();

		//EmpVOmemberからgetempVOmemberを定義します
		ResultVO resultVO = null;

		//ファイルを開き、読み込みます
		try (BufferedReader bufferedReader = new BufferedReader(new FileReader("src/" + fileName))) {

			//ファイルの１行を読み込みがnullでなくなるまで繰り返す。
			String OneRecord;

			while ((OneRecord = bufferedReader.readLine()) != null) {

				//コメントの場合は、継続します。
				if (OneRecord.startsWith(DELIMITER) || OneRecord.startsWith(".")) {
					continue;
				}

				//\tで分割を行い、配列に格納します。
				String[] arrays = OneRecord.split(DELIMITER);

				//受け取った引数
				String nameJudge = arrays[0];
				String birthJudge = arrays[3];

				//一致した場合はループを抜ける。

				if (Year.equals(arrays[0]) && Month.equals(arrays[1]) && Day.equals(arrays[2])
						&& StartTime.equals(arrays[3]) && EndTime.equals(arrays[4])) {

					//配列データをEmpVOmember中のコンストラクタに設定します。
					resultVO = new ResultVO();
					resultVO.setYear(arrays[0]);
					resultVO.setMonth(arrays[1]);
					resultVO.setDay(arrays[2]);
					resultVO.setStartTime(arrays[3]);
					resultVO.setEndTime(arrays[4]);
					resultVO.setContents(arrays[5]);
					resultVO.setResult(arrays[6]);
					resultVO.setFlag(arrays[7]);
					resultVO.setOthers(arrays[8]);

					break;
				}
				//			else if(Name.equals(arrays[0])==false||Birth.equals(arrays[3])==false){
				//					System.err.println("名前、または生年月日が間違っています。");
				//
				//					//そのあとに追加機能で、全件検索、登録、削除、更新機能に戻るかを確認する
				//					//機能をつけようと思います。！！！！！！！！！！！！！
				//					break;
				//				}
			}
			//ファイルが開けないときの例外処理
		} catch (FileNotFoundException fileNotFoundException) {
			System.out.println("ファイルが開けません");
			fileNotFoundException.printStackTrace();

			//ファイルが空文字の場合の例外処理
		} catch (NullPointerException nullPointerException) {
			System.out.println("ファイル名が空文字です。");
			nullPointerException.printStackTrace();

			//ファイルデータを読み出せないときの例外処理
		} catch (IOException ioException) {
			System.out.println("データを読み出せません。");
			ioException.printStackTrace();
		}
		return resultVO;
	}

	/**
	 * 挿入機能
	 *
	 * @param fileName
	 * @return
	 */
	public void Insert(ResultVO resultVO) {

		System.out.println(fileName);

		//ファイルを開き、読み込みます
		try {
			//ファイルに追記します。
			FileWriter filewriter = new FileWriter("src/" + fileName, true);
			BufferedWriter bufferedWriter = new BufferedWriter(filewriter);

			//\tで分割を行い、配列に格納します。
			bufferedWriter.write(resultVO.getYear() + DELIMITER);
			bufferedWriter.write(resultVO.getMonth() + DELIMITER);
			bufferedWriter.write(resultVO.getDay() + DELIMITER);
			bufferedWriter.write(resultVO.getStartTime() + DELIMITER);
			bufferedWriter.write(resultVO.getEndTime() + DELIMITER);
			bufferedWriter.write(resultVO.getContents() + DELIMITER);
			bufferedWriter.write(resultVO.getResult() + DELIMITER);
			bufferedWriter.write(resultVO.getFlag() + DELIMITER);
			bufferedWriter.write(resultVO.getOthers());

			//改行
			bufferedWriter.newLine();

			//ファイルの書込内容の更新
			bufferedWriter.flush();

			//ファイルの終了
			filewriter.close();

			//ファイルが開けないときの例外処理
		} catch (FileNotFoundException fileNotFoundException) {
			System.out.println("ファイルが開けません");
			fileNotFoundException.printStackTrace();

			//ファイルが空文字の場合の例外処理
		} catch (NullPointerException nullPointerException) {
			System.out.println("ファイル名が空文字です。");
			nullPointerException.printStackTrace();

			//ファイルデータを読み出せないときの例外処理
		} catch (IOException ioException) {
			System.out.println("データを読み出せません。");
			ioException.printStackTrace();
		}
	}

	/**
	 * 更新機能
	 *
	 * @param fileName
	 * @return
	 */
	public void Update(ResultVO resultVO) {

		List<ResultVO> memberList = getAllmulti();
		ResultVO updateVOmember = null;

		//\tで分割を行い、配列に格納します。
		for (int i = 0; i < memberList.size(); i++) {

			//ここで更新するメンバーを検索して、updateVOmemberとします。
			updateVOmember = memberList.get(i);
			if (resultVO.getYear().equals(updateVOmember.getYear()) &&
					resultVO.getMonth().equals(updateVOmember.getMonth()) &&
					resultVO.getDay().equals(updateVOmember.getDay())) {
				memberList.set(i, resultVO);
				break;
			}
		}
		UpdateAll(memberList);
	}

	/**
	 * Listに指定された社員情報でファイルの更新
	 *
	 * @param fileName
	 * @return
	 */
	public void UpdateAll(List<ResultVO> list) {

		//ファイルを開き、読み込みます
		try {
			//ファイルに追記します。
			FileWriter filewriter = new FileWriter("src/" + fileName, false);
			BufferedWriter bufferedWriter = new BufferedWriter(filewriter);

			//\tで分割を行い、配列に格納します。
			for (ResultVO updateVoMember : list) {

				//更新します。
				bufferedWriter.write(updateVoMember.getYear() + DELIMITER);
				bufferedWriter.write(updateVoMember.getMonth() + DELIMITER);
				bufferedWriter.write(updateVoMember.getDay() + DELIMITER);
				bufferedWriter.write(updateVoMember.getStartTime() + DELIMITER);
				bufferedWriter.write(updateVoMember.getEndTime() + DELIMITER);
				bufferedWriter.write(updateVoMember.getContents() + DELIMITER);
				bufferedWriter.write(updateVoMember.getResult() + DELIMITER);
				bufferedWriter.write(updateVoMember.getFlag() + DELIMITER);
				bufferedWriter.write(updateVoMember.getOthers());

				//改行
				bufferedWriter.newLine();

				//ファイルの書込内容の更新
				bufferedWriter.flush();
			}
			//ファイルの終了
			filewriter.close();

			//ファイルが開けないときの例外処理
		} catch (FileNotFoundException fileNotFoundException) {
			System.out.println("ファイルが開けません");
			fileNotFoundException.printStackTrace();

			//ファイルが空文字の場合の例外処理
		} catch (NullPointerException nullPointerException) {
			System.out.println("ファイル名が空文字です。");
			nullPointerException.printStackTrace();

			//ファイルデータを読み出せないときの例外処理
		} catch (IOException ioException) {
			System.out.println("データを読み出せません。");
			ioException.printStackTrace();
		}
	}

	/**
	 * 削除機能
	 * @param resultVO 部員情報
	 */
	public void Delete(ResultVO resultVO) {

		//部員を全件検索します
		List<ResultVO> memberList = getAllmulti();

		//ResultVOの変数初期値をnullとします。
		ResultVO deleteVoMember = null;

		for (int i = 0; i < memberList.size(); i++) {

			//削除候補を検索します。
			deleteVoMember = memberList.get(i);

			if (resultVO.getResult().equals(deleteVoMember.getResult())) {
				memberList.remove(i);
				break;
			}
		}
		UpdateAll(memberList);
	}
}
