/**
 *
 */
package dao;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import vofiles.EmpVOmember;


//GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' IDENTIFIED BY PASSWORD '*6EE196FEC6FD814490A3954273887E57A8517845' WITH GRANT OPTION;
//
//GRANT PROXY ON ''@'' TO 'root'@'localhost' WITH GRANT OPTION;

/**
 * このクラスではデータアクセスオブジェクトとして接続を管理します。
 *
 * @author Kayano
 *
 */
public class MemberDao {

    // JDBCドライバの登録
    String driver   = "org.gjt.mm.mysql.Driver";
    // データベースの指定
    String server   = "localhost";      // MySQLサーバ ( IP または ホスト名 )
    String dbname   = "takahiro";         // データベース名  + "?useUnicode=true&characterEncoding=EUC_JP"
    String url = "jdbc:mysql://" + server + "/" + dbname;
    String user     = "kayano";         // データベース作成ユーザ名
    String password = "7m26ge10";     // データベース作成ユーザパスワード

    private static final String DELIMITER = "\t";
    private String fileName;

    /**
     * コンストラクタ
     *
     * @param fileName ファイル名
     */
    public MemberDao() {
    }

    public List<EmpVOmember> getAllmulti(){
        List<EmpVOmember> list = new ArrayList<EmpVOmember>();
        try {
            Class.forName (driver);
            // データベースとの接続
            Connection con = DriverManager.getConnection(url, user, password);
            // テーブル照会実行
            Statement stmt = con.createStatement ();
            String sql = "SELECT * FROM membername";
//            String countSql = "SELECT COUNT (*) FROM membername";
//            int count = Integer.parseInt(countSql);
            ResultSet rs = stmt.executeQuery (sql);
            // テーブル照会結果を出力
            while(rs.next()){
                   EmpVOmember empVo = new EmpVOmember();
//                 そのうち、検索するテーブルはすべてこのクラスに対して実行するように修正する。
//                   for (int i=0; i<count; i++){
//                	   empVo.
//                   }
                   empVo.setName(rs.getString("Name"));
                   empVo.setNickname(rs.getString("Nickname"));
                   empVo.setAge(rs.getString("Age"));
                   empVo.setBirth(rs.getString("Birth"));
                   empVo.setFrom(rs.getString("From"));
                   empVo.setHighschool(rs.getString("Highschool"));
                   empVo.setPosition(rs.getString("Position"));
                   empVo.setCourse(rs.getString("Course"));
                   empVo.setMessage(rs.getString("Message"));
                   //System.out.println(empVo.getName()+","+empVo.getNickname()+","+empVo.getAge()+","+empVo.getBirth());
                   list.add(empVo);
                }
            // データベースのクローズ
            rs.close();
            stmt.close();
            con.close();
        } catch (SQLException e) {
            System.err.println("SQL failed.");
            e.printStackTrace ();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace ();
        }
        return list;
    }


    /**
     * Member.txtから、部員情報を1行ごとに読み込み全表示し、listを返却します。
     *
     * @param fileName Member.txt
     * @return list 部員情報
     */
    public List<EmpVOmember> getAllmulti2() {

        //String fileName = "src/Members.txt";

        List<EmpVOmember> memberlist = new ArrayList<EmpVOmember>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName))) {
            String OneRecord = null;
            EmpVOmember empVOmember = null;
            while ((OneRecord = bufferedReader.readLine()) != null) {
                String[] arrays = OneRecord.split(DELIMITER);
                empVOmember = new EmpVOmember();
                empVOmember.setName(arrays[0]);
                empVOmember.setNickname(arrays[1]);
                empVOmember.setAge(arrays[2]);
                empVOmember.setBirth(arrays[3]);
                empVOmember.setFrom(arrays[4]);
                empVOmember.setHighschool(arrays[5]);
                empVOmember.setPosition(arrays[6]);
                empVOmember.setCourse(arrays[7]);
                empVOmember.setMessage(arrays[8]);
                memberlist.add(empVOmember);
            }
        } catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ファイルが開けません");
            fileNotFoundException.printStackTrace();
        } catch (NullPointerException nullPointerException) {
            System.out.println("ファイル名が空文字です。");
            nullPointerException.printStackTrace();
        } catch (IOException ioException) {
            System.out.println("データを読み出せません。");
            ioException.printStackTrace();
        }
        return memberlist;
    }

    /**
     * 単一検索機能（指定された部員の情報を検索します）
     *
     * @param fileName1 ファイル名
     * @return
     */
    public EmpVOmember getMono(String Name, String Birth) {

        EmpVOmember getempVOmember = new EmpVOmember();

        try {
            Class.forName (driver);
            // データベースとの接続
            Connection con = DriverManager.getConnection(url, user, password);
            // テーブル照会実行
            Statement stmt = con.createStatement ();
            String sql = "SELECT * FROM membername where Name = '"+Name+"' AND"+" Birth = '"+Birth+"'";
            ResultSet rs = stmt.executeQuery (sql);
            System.out.println(stmt.getResultSet());
            while (rs.next()) {
                    getempVOmember.setName(rs.getString("Name"));
                    getempVOmember.setNickname(rs.getString("Nickname"));
                    getempVOmember.setAge(rs.getString("Age"));
                    getempVOmember.setBirth(rs.getString("Birth"));
                    getempVOmember.setFrom(rs.getString("From"));
                    getempVOmember.setHighschool(rs.getString("Course"));
                    getempVOmember.setPosition(rs.getString("Position"));
                    getempVOmember.setCourse(rs.getString("Highschool"));
                    getempVOmember.setMessage(rs.getNString("Message"));
                    System.out.println("検索できています");
                    break;
                }
        } catch (SQLException e) {
            System.err.println("SQL failed.");
            e.printStackTrace ();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace ();
        }
        return getempVOmember;
    }




    /**
     * 挿入機能
     *
     * @param fileName
     * @return
     */
    public void Insert(EmpVOmember empVOmember) {

        try {
            Class.forName (driver);
            // データベースとの接続
            Connection con = DriverManager.getConnection(url, user, password);
            // テーブル照会実行
            String sql = "INSERT INTO membername (`Name`, `Nickname`, `Age`, `Birth`," +
                    " `From`, `Highschool`, `Position`, `Course`, `Message`" +
                    ") VALUES ('"+empVOmember.getName() + "','"+empVOmember.getNickname() +
                    "','"+empVOmember.getAge() + "','"+empVOmember.getBirth() + "','"+
                    empVOmember.getFrom() +"','"+empVOmember.getHighschool()+"','"+empVOmember.getPosition() +"','"+
                    empVOmember.getCourse() +"','"+empVOmember.getMessage()+"')";
            java.sql.PreparedStatement stmt = con.prepareStatement(sql);
            stmt.close();
            con.close();
        } catch (NullPointerException nullPointerException) {
            System.out.println("ファイル名が空文字です。");
            nullPointerException.printStackTrace();
        } catch (SQLException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }
    }

    /**
     * 更新機能
     *
     * @param fileName
     * @return
     */
    public void Update(EmpVOmember empVOmember) {

        List<EmpVOmember> memberList = getAllmulti();
        EmpVOmember updateVOmember = null;

        for (int i = 0; i < memberList.size(); i++) {

            updateVOmember = memberList.get(i);
            if (empVOmember.getName().equals(updateVOmember.getName())) {
                memberList.set(i, empVOmember);
                break;
            }
        }
        UpdateAll(memberList);
    }

    /**
     * Listに指定された社員情報でファイルの更新
     *
     * @param fileName
     * @return
     */
    public void UpdateAll(List<EmpVOmember> list) {

        //ファイルを開き、読み込みます
        try {
            //ファイルに追記します。
            FileWriter filewriter = new FileWriter(fileName, false);
            BufferedWriter bufferedWriter = new BufferedWriter(filewriter);

            //\tで分割を行い、配列に格納します。
            for (EmpVOmember updateVoMember : list) {

                //更新します。
                bufferedWriter.write(updateVoMember.getName() + DELIMITER);
                bufferedWriter.write(updateVoMember.getNickname() + DELIMITER);
                bufferedWriter.write(updateVoMember.getAge() + DELIMITER);
                bufferedWriter.write(updateVoMember.getBirth() + DELIMITER);
                bufferedWriter.write(updateVoMember.getFrom() + DELIMITER);
                bufferedWriter.write(updateVoMember.getHighschool() + DELIMITER);
                bufferedWriter.write(updateVoMember.getPosition() + DELIMITER);
                bufferedWriter.write(updateVoMember.getCourse() + DELIMITER);
                bufferedWriter.write(updateVoMember.getMessage());

                //改行
                bufferedWriter.newLine();

                //ファイルの書込内容の更新
                bufferedWriter.flush();
            }
            //ファイルの終了
            filewriter.close();

            //ファイルが開けないときの例外処理
        } catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ファイルが開けません");
            fileNotFoundException.printStackTrace();

            //ファイルが空文字の場合の例外処理
        } catch (NullPointerException nullPointerException) {
            System.out.println("ファイル名が空文字です。");
            nullPointerException.printStackTrace();

            //ファイルデータを読み出せないときの例外処理
        } catch (IOException ioException) {
            System.out.println("データを読み出せません。");
            ioException.printStackTrace();
        }
    }

    /**
     * 削除機能
     * @param empVOmember 部員情報
     */
    public void Delete(EmpVOmember empVOmember) {

        //部員を全件検索します
        List<EmpVOmember> memberList = getAllmulti();

        //EmpVOMemberの変数初期値をnullとします。
        EmpVOmember deleteVoMember = null;

        for (int i = 0; i < memberList.size(); i++) {

            //削除候補を検索します。
            deleteVoMember = memberList.get(i);

            if (empVOmember.getName().equals(deleteVoMember.getName())) {
                memberList.remove(i);
                break;
            }
        }
        UpdateAll(memberList);
    }

    public List<EmpVOmember> getAllmultiFor1phase() {
        List<EmpVOmember> memberlist = new ArrayList<EmpVOmember>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader("src/" + fileName))) {
            String OneRecord = null;
            EmpVOmember empVOmember = null;
            while ((OneRecord = bufferedReader.readLine()) != null) {
                String[] arrays = OneRecord.split(DELIMITER);
                empVOmember = new EmpVOmember();
                empVOmember.setName(arrays[0]);
                empVOmember.setNickname(arrays[1]);
                empVOmember.setAge(arrays[2]);
                empVOmember.setBirth(arrays[3]);
                empVOmember.setFrom(arrays[4]);
                empVOmember.setHighschool(arrays[5]);
                empVOmember.setPosition(arrays[6]);
                empVOmember.setCourse(arrays[7]);
                empVOmember.setMessage(arrays[8]);
                memberlist.add(empVOmember);
            }
        } catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ファイルが開けません");
            fileNotFoundException.printStackTrace();
        } catch (NullPointerException nullPointerException) {
            System.out.println("ファイル名が空文字です。");
            nullPointerException.printStackTrace();
        } catch (IOException ioException) {
            System.out.println("データを読み出せません。");
            ioException.printStackTrace();
        }
        return memberlist;
    }
}
