/**
 *
 */
package Viewer;

import vofiles.EmpVOmember;
import vofiles.ResultVO;
import vofiles.ScheduleVO;

/**
 * @author Kayano
 *
 */
public class PrintInfo {

	private static final String DELIMiTER = "\t";

	/**
	 * 部員pロフィールのヘッダーを表示するメソッド
	 */
	public static void printHeaderMember() {
		System.out.println("Name" + "\t" + "NickName" + "\t" + "Age" + "\t" + "Birth" + "\t" +
				"From" + "\t" + "Course" + "\t" + "Position" + "\t" + "Highschool" + "\t" + "Message");
	}

	/**
	 * @param empVOmember 部員のプロフィール情報を表示するメソッド
	 */
	public static void printInfoMember(EmpVOmember empVOmember) {
		System.out.println(empVOmember.getName() + DELIMiTER +
				empVOmember.getNickname() + DELIMiTER +
				empVOmember.getAge() + DELIMiTER +
				empVOmember.getBirth() + DELIMiTER +
				empVOmember.getFrom() + DELIMiTER +
				empVOmember.getCourse() + DELIMiTER +
				empVOmember.getPosition() + DELIMiTER +
				empVOmember.getHighschool() + DELIMiTER +
				empVOmember.getMessage() + DELIMiTER);
	}

	public static void printHeaderSchedule() {
		System.out.println("Year" + "\t" + "Month" + "\t" + "Day" + "\t" + "StartTime" + "\t" +
				"EndTime" + "\t" + "Category" + "\t" + "Contents" + "\t" + "JoinMember" + "\t" + "Others");
	}

	/**
	 * @param sVO スケジュール情報を表示するメソッド
	 */
	public static void printInfoSchedule(ScheduleVO sVO) {
		System.out.println(sVO.getYear() + DELIMiTER +
				sVO.getMonth() + DELIMiTER +
				sVO.getDay() + DELIMiTER +
				sVO.getStartTime() + DELIMiTER +
				sVO.getEndTime() + DELIMiTER +
				sVO.getCategory() + DELIMiTER +
				sVO.getContents() + DELIMiTER +
				sVO.getJoinMember() + DELIMiTER +
				sVO.getOthers() + DELIMiTER);
	}

	/**
	 *
	 */
	public static void printHeaderResult() {
		System.out.println("Year" + "\t" + "Month" + "\t" + "Day" + "\t" + "StartTime" + "\t" +
				"EndTime" + "\t" + "Contents" + "\t" + "Result" + "\t" + "Flag" + "\t" + "Others");
	}

	/**
	 * @param resultVO 部員のプロフィール情報を表示するメソッド
	 */
	public static void printInfoResult(ResultVO resultVO) {
		System.out.println(resultVO.getYear() + DELIMiTER +
				resultVO.getMonth() + DELIMiTER +
				resultVO.getDay() + DELIMiTER +
				resultVO.getStartTime() + DELIMiTER +
				resultVO.getEndTime() + DELIMiTER +
				resultVO.getCategory() + DELIMiTER +
				resultVO.getContents() + DELIMiTER +
				resultVO.getJoinMember() + DELIMiTER +
				resultVO.getOthers() + DELIMiTER);
	}

}
