package Member;

import java.util.List;

import myUtil.DateUtil;
import myUtil.Enumber;
import myUtil.Inputclass;
import myUtil.TypeCheckUtil;
import vofiles.EmpVOmember;
import Viewer.PrintInfo;
import dao.MemberDao;

public class MemberDeleteBean implements MemberBean {

    private String Name;
    private String Birth;
    private EmpVOmember empVOmember;

    @Override
    public boolean input(String fileName) {

        boolean flg = false;

        MemberDao ezDao = new MemberDao();

        Name = Inputclass.getString("メンバーを入力してください。");
        Birth = Inputclass.getString("生年月日を入力してください。");

        TypeCheckUtil.checkLengthRestrict(Name, Name.length(), Enumber.twenty);
        DateUtil.calenderUtil(Birth);

        empVOmember = ezDao.getMono(Name, Birth);
        if (empVOmember == null) {
            System.err.println("該当者がいません。");
            //追加機能を設定したい。
            return flg;
        }

        PrintInfo.printHeaderMember();
        PrintInfo.printInfoMember(empVOmember);
        System.out.println();

        //データの削除確認
        if (Inputclass.getString("削除しますか<y/n>？").equalsIgnoreCase("y")) {
            //			flg=ConfirmMethod.judgement();
            //			if(ConfirmMethod.judgement()==true){
            //				System.out.println("削除しますよ！");
            flg = true;
        }
        return flg;
    }

    @Override
    public void execute(String fileName) {
        MemberDao ezDao = new MemberDao();
        ezDao.Delete(empVOmember);
        System.out.println("削除が完了しました。");
    }

    @Override
    public EmpVOmember executeReturn(String fileName) {
        MemberDao ezDao = new MemberDao();
        ezDao.Delete(empVOmember);
        System.out.println("削除が完了しました。");
        return empVOmember;
    }

    @Override
    public List<EmpVOmember> executeReturnAll(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    /* (非 Javadoc) Applet使用持に実行するメソッド
     * @see Member.MemberBean#executeReturn(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    @Override
    public EmpVOmember executeReturn(String fileName, String checkName, String checkBirthDay, String checkDetails) {

        EmpVOmember empVOmember;

        Name = checkName;
        Birth = checkBirthDay;

        TypeCheckUtil.checkLengthRestrict(Name, Name.length(), Enumber.twenty);
        DateUtil.calenderUtil(Birth);

        MemberDao ezDao = new MemberDao();
        empVOmember = ezDao.getMono(Name, Birth);
        if (empVOmember == null) {
            System.err.println("該当者がいません。");
            //追加機能を設定したい。
            //return flg;(nullのときは加tchするように修正してください。）
        }

        PrintInfo.printHeaderMember();
        PrintInfo.printInfoMember(empVOmember);
        System.out.println();

        ezDao.Delete(empVOmember);
        System.out.println("削除が完了しました。");
        return empVOmember;
    }

    @Override
    public EmpVOmember executeInsertReturn(String fileName, String[] emp) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public void execute() {
        // TODO 自動生成されたメソッド・スタブ

    }

    @Override
    public List<EmpVOmember> executeReturnAll() {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public boolean input() {
        // TODO 自動生成されたメソッド・スタブ
        return false;
    }

}
