package Member;

import java.util.List;

import myUtil.DateUtil;
import myUtil.Enumber;
import myUtil.Inputclass;
import myUtil.TypeCheckUtil;
import vofiles.EmpVOmember;
import Viewer.PrintInfo;
import dao.MemberDao;

public class MemberUpdateBean implements MemberBean {

    private String Name;
    private String Birth;
    private EmpVOmember empVOmember;

    @Override
    public boolean input(String fileName) {

        boolean flg = false;

        Name = Inputclass.getString("メンバーを入力してください");
        Birth = Inputclass.getString("生年月日を入力してください。");
        memberUpdateCheck(fileName, flg);
        memberUpdateDate(fileName, Name, Birth);
        memberLetterCheck(empVOmember, Name, Birth, fileName);
        return checkUpdate(empVOmember, Name, Birth, fileName);
    }

    private void memberLetterCheck(EmpVOmember empVOmember2, String name2, String birth2, String fileName) {
        //文字数チェック
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getNickname(), empVOmember2.getNickname().length(),
                Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getAge(), empVOmember2.getAge().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getFrom(), empVOmember2.getFrom().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getCourse(), empVOmember2.getCourse().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getPosition(), empVOmember2.getPosition().length(),
                Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getHighschool(), empVOmember2.getHighschool().length(),
                Enumber.twenty);
        TypeCheckUtil
                .checkLengthRestrict(empVOmember2.getMessage(), empVOmember2.getMessage().length(), Enumber.twenty);
    }

    private boolean memberUpdateCheck(String fileName, boolean flg) {
        //文字チェック
        TypeCheckUtil.checkLengthRestrict(Name, Name.length(), Enumber.twenty);
        DateUtil.calenderUtil(Birth);

        MemberDao ezDao = new MemberDao(fileName);

        //既に登録されている場合は実行メニュー画面に戻る。

        empVOmember = ezDao.getMono(Name, Birth);
        if (empVOmember == null) {
            System.err.println("登録されていません。");
            return flg;
        }
        PrintInfo.printHeaderMember();
        PrintInfo.printInfoMember(empVOmember);
        System.out.println();

        //データ修正確認
        if (Inputclass.getString("修正しますか<y/n>？").equalsIgnoreCase("y") == false) {
            return flg;
        }
        return flg;
    }

    private void memberUpdateDate(String fileName, String name2, String birth2) {
        empVOmember = new EmpVOmember();

        String Nickname = Inputclass.getString("ニックネームを入力してください");
        String Age = Inputclass.getString("年齢：");
        String From = Inputclass.getString("出身地");
        String Course = Inputclass.getString("所属コース");
        String Position = Inputclass.getString("ポジション");
        String Highschool = Inputclass.getString("出身校");
        String Message = Inputclass.getString("一言メッセージ");

        empVOmember.setName(Name);
        empVOmember.setBirth(Birth);
        empVOmember.setNickname(Nickname);
        empVOmember.setAge(Age);
        empVOmember.setFrom(From);
        empVOmember.setCourse(Course);
        empVOmember.setPosition(Position);
        empVOmember.setHighschool(Highschool);
        empVOmember.setMessage(Message);
    }

    private boolean checkUpdate(EmpVOmember empVOmemberAfter, String Name, String Birth, String fileName) {
        if (Inputclass.getString("更新内容を表示しますか？").equalsIgnoreCase("y")) {
            MemberDao ezDao = new MemberDao(fileName);
            EmpVOmember empVOmemberBefore = ezDao.getMono(Name, Birth);
            System.out.println("更新前のデータ");
            PrintInfo.printHeaderMember();
            PrintInfo.printInfoMember(empVOmemberBefore);
            System.out.println("更新後のデータ");
            PrintInfo.printInfoMember(empVOmemberAfter);
        }
        if (Inputclass.getString("内容を更新しますか？<y/n>？").equalsIgnoreCase("y")) {
            return true;
        }
        return false;
    }

    @Override
    public void execute(String fileName) {
        MemberDao ezDao = new MemberDao(fileName);
        ezDao.Update(empVOmember);
        System.out.println("修正が完了しました。");
    }

    @Override
    public EmpVOmember executeReturn(String fileName) {
        MemberDao ezDao = new MemberDao(fileName);
        ezDao.Update(empVOmember);
        System.out.println("修正が完了しました。");
        return null;
    }

    @Override
    public List<EmpVOmember> executeReturnAll(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeReturn(String fileName, String checkNumber, String checkMenuname, String checkDetails) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeInsertReturn(String fileName, String[] emp) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

}
