package Member;

import java.util.List;

import myUtil.DateUtil;
import myUtil.Enumber;
import myUtil.Inputclass;
import myUtil.TypeCheckUtil;
import vofiles.EmpVOmember;
import Viewer.PrintInfo;
import dao.MemberDao;

public class MemberSearchBean implements MemberBean {

    private String name = null;
    private String birth = null;
    private EmpVOmember empVOmember;

    @Override
    public boolean input(String fileName) {
        boolean flg = false;
        name = Inputclass.getString("メンバーの名前を入力してください。");
        birth = Inputclass.getString("生年月日を入力してください。");

        //検索チェック処理
        TypeCheckUtil.checkLengthRestrict(name, name.length(), Enumber.twenty);
        DateUtil.calenderUtil(birth);

        MemberDao ezDao = new MemberDao(fileName);
        empVOmember = ezDao.getMono(name, birth);

        if (empVOmember == null) {
            System.err.println("該当者がいません");
        } else {
            flg = true;
        }
        return flg;
    }

    @Override
    public void execute(String fileName) {
        PrintInfo.printHeaderMember();
        PrintInfo.printInfoMember(empVOmember);
    }

    @Override
    public EmpVOmember executeReturn(String fileName, String name, String birthday, String checkDetails) {

        this.name = name;
        this.birth = birthday;

        //検索チェック処理
        TypeCheckUtil.checkLengthRestrict(name, name.length(), Enumber.twenty);
        DateUtil.calenderUtil(birth);

        MemberDao ezDao = new MemberDao(fileName);
        empVOmember = ezDao.getMono(name, birth);

        if (empVOmember == null) {
            System.err.println("該当者がいません");
        }

        return empVOmember;
    }

    @Override
    public List<EmpVOmember> executeReturnAll(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeReturn(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeInsertReturn(String fileName, String[] emp) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }


}
