package Member;

import java.util.List;

import myUtil.DateUtil;
import myUtil.Enumber;
import myUtil.Inputclass;
import myUtil.TypeCheckUtil;
import vofiles.EmpVOmember;
import Viewer.PrintInfo;
import dao.MemberDao;

public class MemberInsertBean implements MemberBean {

    private String Name;

    private String Birth;

    private EmpVOmember empVOmember = null;

    private String fileName = "Members.txt";

    @Override
    public boolean input(String fileName) {

        boolean flg = false;
        Name = Inputclass.getString("メンバーを入力してください");
        Birth = Inputclass.getString("生年月日を入力してください");

        //登録処理チェック
        memberInsertCheck(fileName, flg, Name, Birth);

        //該当者が存在しない場合は、追加します。
        memberInsertDate(flg, Name, Birth);

        memberLetterCheck(empVOmember, fileName, Name, Birth);

        return checkUpdate(empVOmember, Name, Birth, fileName);

    }

    private void memberInsertDate(boolean flg, String Name, String Birth) {
        String Nickname = Inputclass.getString("ニックネームを入力してください");
        String Age = Inputclass.getString("年齢：");
        String From = Inputclass.getString("出身地");
        String Course = Inputclass.getString("所属コース");
        String Position = Inputclass.getString("ポジション");
        String Highschool = Inputclass.getString("出身校");
        String Message = Inputclass.getString("一言メッセージ");
        empVOmember = new EmpVOmember();
        empVOmember.setName(Name);
        empVOmember.setBirth(Birth);
        empVOmember.setNickname(Nickname);
        empVOmember.setAge(Age);
        empVOmember.setFrom(From);
        empVOmember.setCourse(Course);
        empVOmember.setPosition(Position);
        empVOmember.setHighschool(Highschool);
        empVOmember.setMessage(Message);
    }

    private boolean memberInsertCheck(String fileName, boolean flg, String Name, String Birth) {

        MemberDao ezDao = new MemberDao(fileName);

        //検索チェック処理
        TypeCheckUtil.checkLengthRestrict(Name, Name.length(), Enumber.twenty);
        DateUtil.calenderUtil(Birth);

        if (ezDao.getMono(Name, Birth) != null) {
            System.out.println("該当者がいるため、更新することができません。");
            return false;
        } else {
            System.out.println("該当者はいないので、登録処理を行います。");
        }
        return true;
    }

    private void memberLetterCheck(EmpVOmember empVOmember2, String name2, String birth2, String fileName) {
        //文字数チェック
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getNickname(), empVOmember2.getNickname().length(),
                Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getAge(), empVOmember2.getAge().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getFrom(), empVOmember2.getFrom().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getCourse(), empVOmember2.getCourse().length(), Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getPosition(), empVOmember2.getPosition().length(),
                Enumber.twenty);
        TypeCheckUtil.checkLengthRestrict(empVOmember2.getHighschool(), empVOmember2.getHighschool().length(),
                Enumber.twenty);
        TypeCheckUtil
                .checkLengthRestrict(empVOmember2.getMessage(), empVOmember2.getMessage().length(), Enumber.twenty);
    }

    private boolean checkUpdate(EmpVOmember empVOmemberAfter, String name2, String birth2, String fileName) {

        if (Inputclass.getString("登録内容を表示しますか？").equalsIgnoreCase("y")) {
            MemberDao ezDao = new MemberDao(fileName);
            EmpVOmember empVOmemberBefore = ezDao.getMono(Name, Birth);
            System.out.println("更新前のデータ");
            PrintInfo.printHeaderMember();
            PrintInfo.printInfoMember(empVOmemberBefore);
            System.out.println("更新後のデータ");
            PrintInfo.printInfoMember(empVOmemberAfter);
        }

        if (Inputclass.getString("登録しますか<y/n>？").equalsIgnoreCase("y")) {
            return true;
        }
        return false;
    }

    @Override
    public void execute(String fileName) {
        MemberDao ezDao = new MemberDao(fileName);
        ezDao.Insert(empVOmember);
        System.out.println("登録が完了しました。");
    }

    @Override
    public EmpVOmember executeInsertReturn(String fileName,String[] emp) {
        String Name = emp[0];
        String Birth = emp[2];
        String Nickname = emp[1];
        String Age = emp[3];
        String From = emp[4];
        String Course = emp[5];
        String Position = emp[6];
        String Highschool = emp[7];
        String Message = emp[8];
        empVOmember = new EmpVOmember();
        empVOmember.setName(Name);
        empVOmember.setBirth(Birth);
        empVOmember.setNickname(Nickname);
        empVOmember.setAge(Age);
        empVOmember.setFrom(From);
        empVOmember.setCourse(Course);
        empVOmember.setPosition(Position);
        empVOmember.setHighschool(Highschool);
        empVOmember.setMessage(Message);


        boolean flg = false;
        //登録処理チェック
        memberInsertCheck(fileName, flg, Name, Birth);

        //該当者が存在しない場合は、追加します。
        EmpVOmember insEmp =memberInsertDate(flg, Name, Birth, Nickname, Age, From, Course, Position,Highschool,Message);

        memberLetterCheck(empVOmember, fileName, Name, Birth);

        System.out.println("dao実行前");

        MemberDao ezDao = new MemberDao(fileName);
        ezDao.Insert(empVOmember);
        System.out.println("登録が完了しました。");
        //return checkUpdate(empVOmember, Name, Birth, fileName);

        //最後にテキストに反映させる。
        return empVOmember;
    }

    //このメソッドはアプレット用のチェックです。
    private EmpVOmember memberInsertDate(boolean flg, String name, String birth, String nickname, String age, String from,
        String course, String position, String highschool, String message) {
        empVOmember = new EmpVOmember();
        empVOmember.setName(name);
        empVOmember.setBirth(birth);
        empVOmember.setNickname(nickname);
        empVOmember.setAge(age);
        empVOmember.setFrom(from);
        empVOmember.setCourse(course);
        empVOmember.setPosition(position);
        empVOmember.setHighschool(highschool);
        empVOmember.setMessage(message);
        return empVOmember;

    }

    @Override
    public List<EmpVOmember> executeReturnAll(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeReturn(String fileName, String checkNumber, String checkMenuname, String checkDetails) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    @Override
    public EmpVOmember executeReturn(String fileName) {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

}
