/**
 *
 */
package Member;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Kayano
 *
 */
public class MemberBeanFactory {

	/**
	* keyをメニュー番号、valueをBeanインスタンスとして、
	* マップを定義します。
	*/

	private static Map<Integer, MemberBean> map = null;
	/**
	 * static initializerで初期化する。
	 */
	static {
		map = new HashMap<Integer, MemberBean>();
		map.put(1, new MemberAllPrintBean());
		map.put(2, new MemberSearchBean());
		map.put(3, new MemberInsertBean());
		map.put(4, new MemberDeleteBean());
		map.put(5, new MemberUpdateBean());
		map.put(6, new MemberExitBean());
	}

	/**
	 * @param menuNo メニュー番号
	 * @return メニュー番号に対応したBean
	 */
	public static MemberBean get(int menuNo) {
		return map.get(menuNo);
	}

}
