package com.xxxxxxx.drvpp.fw.common.util;

import java.util.Map;

import org.springframework.context.ApplicationContext;

import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

public class SettingFactory {
	private static final String SYSTEM_SETTING_MAP = "systemSettingMap";

	private static class SingletonHolder {
		private static final SettingFactory instance = new SettingFactory();
	}
	public static SettingFactory getInstance() {
		return SingletonHolder.instance;
	}
	
	public Setting getSystemSetting(){
		return getSystemSetting(SYSTEM_SETTING_MAP);
	}

	public Setting getSystemSetting(String key){
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();
		Map<String, Object> map = (Map<String, Object>)applicationContext.getBean(key);
		return new SettingImpl(map);
	}
}
