package com.xxxxxxx.drvpp.fw.common.util;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.xxxxxxx.drvpp.fw.common.exception.FwRuntimeException;

public class BeanFactoryBuilder {
	private ApplicationContext applicationContext;
	
	private static class BeanFactoryBuilderHolder {
		private static final BeanFactoryBuilder instance = new BeanFactoryBuilder();
	}
	public static BeanFactoryBuilder getInstance() {
		BeanFactoryBuilderHolder.instance.init();
		return BeanFactoryBuilderHolder.instance;
	}

	private void init() {
		applicationContext = new ClassPathXmlApplicationContext(
				"applicationContext.xml");
		if (applicationContext == null){
			throw new FwRuntimeException(null);
		}
	}

	private BeanFactoryBuilder(){
		
	}
	
	public ApplicationContext build(){
		return applicationContext;
	}
}
