package com.xxxxxxx.drvpp.fw.common.mybatis;

import java.io.IOException;
import java.io.Reader;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class MyBatisSessionFactory {
	private SqlSessionFactory sqlMapper;
	private String resource = "mybatis.xml";

	private static class MyBatisSessionFactoryHolder {
		private static final MyBatisSessionFactory instance = new MyBatisSessionFactory();
	}
	public static MyBatisSessionFactory getInstance() {
		return MyBatisSessionFactoryHolder.instance;
	}

	private MyBatisSessionFactory(){
		
	}
	
	public SqlSession openSession() {
		synchronized (this){
			if (sqlMapper == null){
				Reader reader;
				try {
					reader = Resources.getResourceAsReader(resource);
					SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
					sqlMapper = builder.build(reader);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}				
			}
		}
		return sqlMapper.openSession();
	}
	
	public String getResource() {
		return resource;
	}

	public void setResource(String resource) {
		this.resource = resource;
	}
}
