package com.xxxxxxx.drvpp.fw.common.log;

import org.springframework.context.ApplicationContext;

import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

public class LoggerFactoryBuilder {
	private LoggerFactory loggerFactory;

	private static class LoggerFactoryBuilderHolder {
		private static final LoggerFactoryBuilder instance = new LoggerFactoryBuilder();
	}
	public static LoggerFactoryBuilder getInstance() {
		LoggerFactoryBuilderHolder.instance.init();
		return LoggerFactoryBuilderHolder.instance;
	}

	private LoggerFactoryBuilder(){
		
	}

	private void init() {
		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		loggerFactory = (LoggerFactory) applicationContext.getBean("loggerFactory");
	}
	
	public LoggerFactory getLoggerFactory(){
		return loggerFactory;
	}
}
