package com.xxxxxxx.drvpp.fw.common.aop;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;

import com.xxxxxxx.drvpp.fw.common.log.Logger;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactory;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactoryBuilder;
import com.xxxxxxx.drvpp.fw.common.util.Parameter;

public class LoggerAspect {
	private LoggerFactory loggerFactory;

	public void before(JoinPoint jp) {
    	LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder.getInstance();
    	loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		
		// メソッド開始時にWeavingするAdvice
		Signature sig = jp.getSignature();
		//Logger log = Logger.getLogger(sig.getClass());
    	Logger log = loggerFactory.getLogger(this.getClass());
		log.info(sig);

		Object[] args = jp.getArgs();
		Parameter parameter = (Parameter)args[0];
		Object target = jp.getTarget();
		//Logger bizLog = Logger.getLogger(target.getClass());
		Logger bizLog = loggerFactory.getLogger(target.getClass());
		parameter.setLog(bizLog);
	}

	public void after() {
		// メソッド終了後にWeavingするAdvice
	}

	public void afterReturning(JoinPoint jp, Parameter parameter) {
		// メソッド呼出が例外の送出なしに終了した際に呼ばれるAdvice
		// System.out.println("Hello AfterReturning! *** メソッドを呼んだ後に出てくるよ");
		// // System.out.println("-----> return value = " + ret);
		// Signature sig = jp.getSignature();
		// System.out.println("-----> メソッド名を取得するよ：" + sig.getName());
		// Object[] o = jp.getArgs();
		// System.out.println("-----> 仮引数の値を取得するよ：" + o[0]);
		Signature sig = jp.getSignature();
		//Logger log = Logger.getLogger(sig.getClass());
    	Logger log = loggerFactory.getLogger(this.getClass());
		log.info(sig);
	}

	public Integer around(ProceedingJoinPoint pjp) throws Throwable {
		// メソッド呼出の前後にWeavingするAdvice
		// System.out.println("Hello Around! before *** メソッドを呼ぶ前に出てくるよ!");

		// Signature sig = pjp.getSignature();
		// System.out.println("-----> aop:around メソッド名を取得するよ：" + sig.getName());
		Integer p = (Integer) pjp.proceed();
		// msg = msg + "：結果に勝手に追加しちゃったほげ！";
		// System.out.println("Hello Around! after *** メソッドを呼んだ後に出てくるよ!");
		return p;
	}

	public String around2(ProceedingJoinPoint pjp) throws Throwable {
		// メソッド呼出の前後にWeavingするAdvice
		System.out.println("***pre proceed");

		Signature sig = pjp.getSignature();
		System.out.println("Sig: " + sig.getName());
		String msg = (String) pjp.proceed();
		// msg = msg + "fuga";
		System.out.println("***post proceed");
		return msg;
	}

	public void afterThrowing(Throwable ex) {
		// メソッド呼出が例外を送出した際に呼ばれるAdvice
		// System.out.println("Hello Throwing! *** 例外になったら出てくるよ");
		// System.out.println("exception value = " + ex.toString());
	}
}