package com.xxxxxxx.drvpp.biz.batch.xyz.business;

import java.io.File;

import mockit.Mocked;
import mockit.NonStrictExpectations;

import org.apache.ibatis.session.SqlSession;
import org.dbunit.dataset.IDataSet;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.Assert;

import com.xxxxxxx.drvpp.biz.batch.xyz.business.BusinessA;
import com.xxxxxxx.drvpp.fw.batch.util.BatchParameter;
import com.xxxxxxx.drvpp.fw.common.log.LoggerLog4jImpl;
import com.xxxxxxx.drvpp.fw.common.mybatis.MyBatisSessionFactory;
import com.xxxxxxx.drvpp.fw.common.test.DbTestUtil;
import com.xxxxxxx.drvpp.fw.common.test.TestUtil;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:testApplicationContext.xml")
public class BusinessATest {
	private DbTestUtil dbutil = DbTestUtil.getInstance();
	private TestUtil util = TestUtil.getInstance();

	
	@Mocked
	private BusinessA business;
	private BatchParameter parameter = new BatchParameter();

	@Test
	public void testDoExecute001() {
		BusinessA b = new BusinessA();
		BatchParameter parameter = new BatchParameter();

		LoggerLog4jImpl log = new LoggerLog4jImpl();
		log.init(this.getClass());
		parameter.setLog(log);

		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();
		parameter.setSqlSession(sqlSession);

		int result = b.doExecute(parameter);

		Assert.isTrue(result == 0);
	}

	@Test
	public void testDoExecute002() {
		new NonStrictExpectations() {
			{
				business.doExecute(parameter);
				result = 1;
			}
		};

		int result = business.doExecute(parameter);

		Assert.isTrue(result == 1);
	}

	@Test
	public void testDoExecute003() {
		dbutil.connect();

		File file = util.newFile("testDoExecute003Input.xml");
		IDataSet dataSet1 = dbutil.cleanInsert(file);
		
		file = util.newFile("testDoExecute003Output.xml");
		IDataSet dataSet2 = dbutil.write("pet", file);
		
		Assert.isTrue(dbutil.compare(dataSet1, dataSet2, "pet"));
		
		dbutil.commit();
	}
}
