package com.sample;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpConnect {
	String urlString;
	String request;
	String response;
	String errorMessage;

	/**
	 * 接続先URLを設定する
	 * 
	 * @param url
	 */
	public void setUrl(String url) {
		urlString = url;
	}

	/**
	 * リクエストデータを設定する
	 * 
	 * @param data
	 */
	public void setRequestData(String data) {
		request = data;
	}

	/**
	 * レスポンスデータを出力する
	 * 
	 * @return
	 */
	public String getResponse() {
		return response;
	}

	/**
	 * エラーメッセージを出力する
	 * 
	 * @return
	 */
	public String getErrorMessage() {
		return errorMessage;
	}

	/**
	 * データ送信 (POST)
	 * 
	 * @return boolean
	 */
	public boolean connection() {

		HttpURLConnection conn = null;
		URL url = null;
		OutputStreamWriter osw = null;
		InputStream is = null;
		BufferedReader reader = null;

		try {
			// URLを作成
			url = new URL(urlString);
			// コネクションを作成
			conn = (HttpURLConnection) url.openConnection();
			// メソッドを設定 (POST)
			conn.setDoOutput(true);
			conn.setDoInput(true);
			conn.setRequestMethod("POST");
			// リクエスト方式・ヘッダの設定
			conn.setRequestProperty("Content-Type", "text/xml");
			// リダイレクトの追跡は不要
			HttpURLConnection.setFollowRedirects(false);
			conn.setInstanceFollowRedirects(false);

			// データ送信
			osw = new OutputStreamWriter(conn.getOutputStream());
			if (request.length() > 0)
				osw.write(request);
			osw.flush();
			osw.close();
			osw = null;

			// 入力ストリームを取得
			is = conn.getInputStream();
			// リーダーを作成
			reader = new BufferedReader(new InputStreamReader(is));
			// レスポンスデータを取得
			String s;
			response = "";
			while ((s = reader.readLine()) != null)
				response += s;
			// 入力ストリームを閉じる
			reader.close();
			reader = null;
			is.close();
			is = null;

			// コネクション切断
			conn.disconnect();
			conn = null;

			// 正常終了
			return true;

		} catch (Exception e) {
			e.printStackTrace();
			// エラーメッセージを取得
			errorMessage = e.getMessage();
			// 終了処理
			try {
				if (osw != null) {
					osw.close();
					osw = null;
				}
				if (reader != null) {
					reader.close();
					reader = null;
				}
				if (is != null) {
					is.close();
					is = null;
				}
				if (conn != null) {
					conn.disconnect();
					conn = null;
				}
			} catch (Exception e2) {
			}

			// 異常終了
			return false;
		}
	}
}
