/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.SimpleScope;

public class BindingScope
extends SimpleScope {
    private final ResolvedType m_enclosingType;
    private final ISourceContext m_sourceContext;

    public BindingScope(ResolvedType type, ISourceContext sourceContext, FormalBinding[] bindings) {
        super(type.getWorld(), bindings);
        this.m_enclosingType = type;
        this.m_sourceContext = sourceContext;
    }

    public ResolvedType getEnclosingType() {
        return this.m_enclosingType;
    }

    public ISourceLocation makeSourceLocation(IHasPosition location) {
        return this.m_sourceContext.makeSourceLocation(location);
    }

    public UnresolvedType lookupType(String name, IHasPosition location) {
        String pkgName;
        if (this.m_enclosingType != null && (pkgName = this.m_enclosingType.getPackageName()) != null && !pkgName.equals("")) {
            String[] currentImports = this.getImportedPrefixes();
            String[] newImports = new String[currentImports.length + 1];
            for (int i = 0; i < currentImports.length; ++i) {
                newImports[i] = currentImports[i];
            }
            newImports[currentImports.length] = pkgName.concat(".");
            this.setImportedPrefixes(newImports);
        }
        return super.lookupType(name, location);
    }
}

