/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ibatis.logging.Log;

public abstract class BaseJdbcLogger {
    protected static final Set<String> SET_METHODS = new HashSet<String>();
    protected static final Set<String> EXECUTE_METHODS = new HashSet<String>();
    private Map<Object, Object> columnMap = new HashMap<Object, Object>();
    private List<Object> columnNames = new ArrayList<Object>();
    private List<Object> columnValues = new ArrayList<Object>();
    private Log statementLog;

    public BaseJdbcLogger(Log log) {
        this.statementLog = log;
    }

    protected void setColumn(Object key, Object value) {
        this.columnMap.put(key, value);
        this.columnNames.add(key);
        this.columnValues.add(value);
    }

    protected Object getColumn(Object key) {
        return this.columnMap.get(key);
    }

    protected String getParameterValueString() {
        ArrayList<String> typeList = new ArrayList<String>(this.columnValues.size());
        for (Object value : this.columnValues) {
            if (value == null) {
                typeList.add("null");
                continue;
            }
            typeList.add(value + "(" + value.getClass().getSimpleName() + ")");
        }
        String parameters = ((Object)typeList).toString();
        return parameters.substring(1, parameters.length() - 1);
    }

    protected String getColumnString() {
        return this.columnNames.toString();
    }

    protected void clearColumnInfo() {
        this.columnMap.clear();
        this.columnNames.clear();
        this.columnValues.clear();
    }

    protected String removeBreakingWhitespace(String original) {
        StringTokenizer whitespaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whitespaceStripper.hasMoreTokens()) {
            builder.append(whitespaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }

    protected boolean isDebugEnabled() {
        return this.statementLog.isDebugEnabled() || this.getLog().isDebugEnabled();
    }

    protected void debug(String text) {
        if (this.statementLog.isDebugEnabled()) {
            this.statementLog.debug(text);
        } else {
            this.getLog().debug(text);
        }
    }

    protected abstract Log getLog();

    public Log getStatementLog() {
        return this.statementLog;
    }

    static {
        SET_METHODS.add("setString");
        SET_METHODS.add("setInt");
        SET_METHODS.add("setByte");
        SET_METHODS.add("setShort");
        SET_METHODS.add("setLong");
        SET_METHODS.add("setDouble");
        SET_METHODS.add("setFloat");
        SET_METHODS.add("setTimestamp");
        SET_METHODS.add("setDate");
        SET_METHODS.add("setTime");
        SET_METHODS.add("setArray");
        SET_METHODS.add("setBigDecimal");
        SET_METHODS.add("setAsciiStream");
        SET_METHODS.add("setBinaryStream");
        SET_METHODS.add("setBlob");
        SET_METHODS.add("setBoolean");
        SET_METHODS.add("setBytes");
        SET_METHODS.add("setCharacterStream");
        SET_METHODS.add("setClob");
        SET_METHODS.add("setObject");
        SET_METHODS.add("setNull");
        EXECUTE_METHODS.add("execute");
        EXECUTE_METHODS.add("executeUpdate");
        EXECUTE_METHODS.add("executeQuery");
    }
}

