/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBuilder {
    protected final Configuration configuration;
    protected final TypeAliasRegistry typeAliasRegistry;
    protected final TypeHandlerRegistry typeHandlerRegistry;

    public BaseBuilder(Configuration configuration) {
        this.configuration = configuration;
        this.typeAliasRegistry = this.configuration.getTypeAliasRegistry();
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected String stringValueOf(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    protected Boolean booleanValueOf(String value, Boolean defaultValue) {
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    protected Integer integerValueOf(String value, Integer defaultValue) {
        return value == null ? defaultValue : Integer.valueOf(value);
    }

    protected Set<String> stringSetValueOf(String value, String defaultValue) {
        value = value == null ? defaultValue : value;
        return new HashSet<String>(Arrays.asList(value.split(",")));
    }

    protected JdbcType resolveJdbcType(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            return JdbcType.valueOf(alias);
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException("Error resolving JdbcType. Cause: " + e, e);
        }
    }

    protected ResultSetType resolveResultSetType(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            return ResultSetType.valueOf(alias);
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException("Error resolving ResultSetType. Cause: " + e, e);
        }
    }

    protected ParameterMode resolveParameterMode(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            return ParameterMode.valueOf(alias);
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException("Error resolving ParameterMode. Cause: " + e, e);
        }
    }

    protected Class<?> resolveClass(String alias) {
        if (alias == null) {
            return null;
        }
        try {
            return this.resolveAlias(alias);
        }
        catch (Exception e) {
            throw new BuilderException("Error resolving class . Cause: " + e, e);
        }
    }

    protected TypeHandler<?> resolveInstance(String alias) {
        if (alias == null) {
            return null;
        }
        Class<?> type = this.resolveClass(alias);
        if (type != null && !TypeHandler.class.isAssignableFrom(type)) {
            throw new BuilderException("Type " + type.getName() + " is not a valid TypeHandler because it does not implement TypeHandler interface");
        }
        Class<?> handlerType = type;
        TypeHandler<?> handler = this.resolveInstance(handlerType);
        return handler;
    }

    protected TypeHandler<?> resolveInstance(Class<? extends TypeHandler<?>> handlerType) {
        if (handlerType == null) {
            return null;
        }
        TypeHandler<?> handler = this.typeHandlerRegistry.getMappingTypeHandler(handlerType);
        if (handler == null) {
            try {
                handler = handlerType.newInstance();
            }
            catch (Exception e) {
                throw new BuilderException("Error instantiating class. Cause: " + e, e);
            }
        }
        return handler;
    }

    protected Class<?> resolveAlias(String alias) {
        return this.typeAliasRegistry.resolveAlias(alias);
    }
}

