/*
 * Decompiled with CFR 0.152.
 */
package nii.enactment.productTransfer.graphicalsimulator;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import nii.enactment.productTransfer.graphicalsimulator.ContAction;
import nii.enactment.productTransfer.graphicalsimulator.Position;
import nii.enactment.productTransfer.graphicalsimulator.Product;
import nii.enactment.productTransfer.graphicalsimulator.Recorder;
import nii.enactment.productTransfer.graphicalsimulator.Robot;
import nii.enactment.productTransfer.graphicalsimulator.WindowInterface;

public class Warehouse
extends JPanel
implements WindowInterface {
    private int width = 480;
    private int height = 300;
    private int w = this.width / 6;
    private int m = this.width / 2;
    private int e = this.width / 6 * 5;
    private Robot robot = new Robot(this.w);
    private Product product;
    private Position productIs;
    private Position robotIs = Position.w;
    private Recorder recorder;

    Warehouse(Recorder recorder) {
        this.product = new Product(this.e);
        this.productIs = Position.e;
        this.recorder = recorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        BevelBorder border = new BevelBorder(0, Color.black, Color.black);
        this.setBorder(border);
    }

    public void resetSituation() {
        this.robotIs = Position.w;
        this.productIs = Position.e;
        this.recorder.record("[Reset Situation]");
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLUE);
        g.drawLine(this.width / 3, this.height, this.width / 3, 0);
        g.drawLine(2 * this.width / 3, this.height, 2 * this.width / 3, 0);
        Font font1 = new Font("Arial", 0, 16);
        g2.setFont(font1);
        g2.setColor(Color.black);
        g2.drawString("w", this.w - 5, 50);
        g2.drawString("m", this.m - 5, 50);
        g2.drawString("e", this.e - 5, 50);
        g.drawImage(this.robot.getRobot(), this.robot.getPositionForDraw(), 70, this);
        if (this.robot.getArrow() != null) {
            g.drawImage(this.robot.getArrow(), this.robot.getArrowX(), this.robot.getArrowY(), this);
        }
        g.drawImage(this.product.getImage(), this.product.getX(), this.product.getY(), this);
    }

    @Override
    public void arrive(Position p) {
        if (p == Position.e) {
            this.robot.arrive(this.e);
            this.robotIs = Position.e;
            this.recorder.record("arrive.e");
        } else if (p == Position.m) {
            this.robot.arrive(this.m);
            this.robotIs = Position.m;
            this.recorder.record("arrive.m");
        } else if (p == Position.w) {
            this.robot.arrive(this.w);
            this.robotIs = Position.w;
            this.recorder.record("arrive.w");
        }
        if (this.product.isPicked()) {
            this.product.setPosition(this.robot.getPosition());
            this.productIs = this.robotIs;
        }
        this.repaint();
    }

    @Override
    public void reset() {
        this.product.setPosition(this.e);
        this.productIs = Position.e;
        this.recorder.record("reset");
        this.repaint();
    }

    @Override
    public void pickupScucess() {
        this.product.pickupsuccess();
        this.robot.eraseArrow();
        this.recorder.record("pickupsuccess");
        this.repaint();
    }

    @Override
    public void pickupFail() {
        this.robot.eraseArrow();
        this.repaint();
    }

    @Override
    public void putdownSuccess() {
        this.product.putsuccess();
        this.robot.eraseArrow();
        this.recorder.record("putsuccess");
        this.repaint();
    }

    @Override
    public void putdownFail() {
        this.robot.eraseArrow();
        this.recorder.record("putfail");
        this.repaint();
    }

    @Override
    public void move(ContAction d) {
        this.robot.move(d);
        if (d == ContAction.MOVE_E) {
            this.recorder.record("move.e");
        } else if (d == ContAction.MOVE_W) {
            this.recorder.record("move.w");
        } else if (d == ContAction.PICKUP) {
            this.recorder.record("pickup");
        } else if (d == ContAction.PUTDOWN) {
            this.recorder.record("putdown");
        }
        this.repaint();
    }

    public boolean isPicked() {
        return this.product.isPicked();
    }

    public Position getRobotPosition() {
        return this.robotIs;
    }

    public Position getProductPosition() {
        return this.productIs;
    }

    public ContAction getRobotAction() {
        return this.robot.getContAction();
    }
}

