/*
 * Decompiled with CFR 0.152.
 */
package nii.enactment.productTransfer.graphicalsimulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import nii.enactment.productTransfer.graphicalsimulator.ContAction;
import nii.enactment.productTransfer.graphicalsimulator.Position;
import nii.enactment.productTransfer.graphicalsimulator.WindowInterface;

public class RobotWindow
extends JPanel
implements WindowInterface {
    private static final int SCALE_DEFAULT = 0;
    int width = 480;
    int height = 300;
    int w = this.width / 6;
    int m = this.width / 2;
    int e = this.width / 6 * 5;
    int robotWidth = 75;
    int robotHeight = 135;
    int robotPosition;
    int productWidth = 80;
    int productHeight = 30;
    boolean picked = false;
    int[] arrowPosition = new int[]{-1, -1};
    int[] productPosition = new int[]{this.e - this.productWidth / 2, 230};
    Image product;
    Image arrowR;
    Image arrowL;
    Image arrowD;
    Image arrowU;
    Image robot;
    Image currArrow = null;

    RobotWindow() {
        this.setPreferredSize(new Dimension(this.width, this.height));
        try {
            this.arrowR = ImageIO.read(new File("./Images/arrowR.png")).getScaledInstance(50, 20, 0);
            this.arrowL = ImageIO.read(new File("./Images/arrowL.png")).getScaledInstance(50, 20, 0);
            this.arrowU = ImageIO.read(new File("./Images/arrowU.png")).getScaledInstance(20, 50, 0);
            this.arrowD = ImageIO.read(new File("./Images/arrowD.png")).getScaledInstance(20, 50, 0);
            this.robot = ImageIO.read(new File("./Images/robot.png")).getScaledInstance(this.robotWidth, this.robotHeight, 0);
            this.product = ImageIO.read(new File("./Images/Product.png")).getScaledInstance(80, 30, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.robotPosition = this.w - this.robotWidth / 2;
        this.setSize(this.width, this.height);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLUE);
        g.drawLine(this.width / 3, this.height, this.width / 3, 0);
        g.drawLine(2 * this.width / 3, this.height, 2 * this.width / 3, 0);
        Font font1 = new Font("Arial", 0, 16);
        g2.setFont(font1);
        g2.setColor(Color.black);
        g2.drawString("w", this.w - 5, 50);
        g2.drawString("m", this.m - 5, 50);
        g2.drawString("e", this.e - 5, 50);
        g.drawImage(this.robot, this.robotPosition, 70, this);
        if (this.currArrow != null) {
            g.drawImage(this.currArrow, this.arrowPosition[0], this.arrowPosition[1], this);
        }
        g.drawImage(this.product, this.productPosition[0], this.productPosition[1], this);
    }

    @Override
    public void arrive(Position p) {
        if (p == Position.e) {
            this.robotPosition = this.e - this.robotWidth / 2;
        } else if (p == Position.m) {
            this.robotPosition = this.m - this.robotWidth / 2;
        } else if (p == Position.w) {
            this.robotPosition = this.w - this.robotWidth / 2;
        }
        this.arrowPosition[1] = 0;
        this.arrowPosition[0] = 0;
        this.currArrow = null;
        if (this.picked) {
            this.productPosition[0] = this.robotPosition + this.robotWidth / 2 - this.productWidth / 2;
        }
        this.repaint();
    }

    @Override
    public void pickupScucess() {
        if (!this.picked) {
            this.productPosition[1] = 150;
            this.productPosition[0] = this.robotPosition + this.robotWidth / 2 - this.productWidth / 2;
            this.picked = true;
        }
        this.currArrow = null;
        this.repaint();
    }

    @Override
    public void putdownSuccess() {
        if (this.picked) {
            this.productPosition[0] = this.robotPosition + this.robotWidth / 2 - this.productWidth / 2;
            this.productPosition[1] = 230;
            this.picked = false;
        }
        this.currArrow = null;
        this.repaint();
    }

    @Override
    public void move(ContAction d) {
        if (d == ContAction.MOVE_E) {
            this.currArrow = this.arrowR;
            this.arrowPosition[0] = this.robotPosition + this.robotWidth;
            this.arrowPosition[1] = 120;
        } else if (d == ContAction.MOVE_W) {
            this.currArrow = this.arrowL;
            this.arrowPosition[0] = this.robotPosition - this.robotWidth / 2;
            this.arrowPosition[1] = 120;
        } else if (d == ContAction.PUTDOWN) {
            this.currArrow = this.arrowD;
            this.arrowPosition[0] = this.robotPosition + this.robotWidth / 2 - 8;
            this.arrowPosition[1] = 190;
        } else if (d == ContAction.PICKUP) {
            this.currArrow = this.arrowU;
            this.arrowPosition[0] = this.robotPosition + this.robotWidth / 2 - 8;
            this.arrowPosition[1] = 190;
        }
        this.repaint();
    }

    @Override
    public void reset() {
    }

    @Override
    public void pickupFail() {
    }

    @Override
    public void putdownFail() {
    }
}

