/*
 * Decompiled with CFR 0.152.
 */
package nii.enactment.productTransfer.graphicalsimulator;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import nii.enactment.productTransfer.graphicalsimulator.ContAction;

public class Robot {
    private static final int SCALE_DEFAULT = 0;
    int width = 75;
    int height = 135;
    int position;
    int positionForDraw;
    int[] arrowPosition = new int[]{-1, -1};
    ContAction currAction;
    Image robot;
    Image arrowR;
    Image arrowL;
    Image arrowU;
    Image arrowD;
    Image currArrow;

    Robot(int p) {
        try {
            this.arrowR = ImageIO.read(new File("./Images/arrowR.png")).getScaledInstance(50, 20, 0);
            this.arrowL = ImageIO.read(new File("./Images/arrowL.png")).getScaledInstance(50, 20, 0);
            this.arrowU = ImageIO.read(new File("./Images/arrowU.png")).getScaledInstance(20, 50, 0);
            this.arrowD = ImageIO.read(new File("./Images/arrowD.png")).getScaledInstance(20, 50, 0);
            this.robot = ImageIO.read(new File("./Images/robot.png")).getScaledInstance(this.width, this.height, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.position = p;
        this.positionForDraw = p - this.width / 2;
    }

    void move(ContAction d) {
        this.currAction = d;
        if (d == ContAction.MOVE_E) {
            this.currArrow = this.arrowR;
            this.arrowPosition[0] = this.positionForDraw + this.width;
            this.arrowPosition[1] = 120;
        } else if (d == ContAction.MOVE_W) {
            this.currArrow = this.arrowL;
            this.arrowPosition[0] = this.positionForDraw - this.width / 2;
            this.arrowPosition[1] = 120;
        } else if (d == ContAction.PUTDOWN) {
            this.currArrow = this.arrowD;
            this.arrowPosition[0] = this.positionForDraw + this.width / 2 - 8;
            this.arrowPosition[1] = 190;
        } else if (d == ContAction.PICKUP) {
            this.currArrow = this.arrowU;
            this.arrowPosition[0] = this.positionForDraw + this.width / 2 - 8;
            this.arrowPosition[1] = 190;
        }
    }

    public void arrive(int p) {
        this.positionForDraw = p - this.width / 2;
        this.position = p;
        this.currArrow = null;
    }

    public void eraseArrow() {
        this.currArrow = null;
    }

    int getPositionForDraw() {
        return this.positionForDraw;
    }

    int getPosition() {
        return this.position;
    }

    Image getRobot() {
        return this.robot;
    }

    Image getArrow() {
        return this.currArrow;
    }

    void setArrowPosition(int x, int y) {
        this.arrowPosition[0] = x;
        this.arrowPosition[1] = y;
    }

    int getArrowX() {
        return this.arrowPosition[0];
    }

    int getArrowY() {
        return this.arrowPosition[1];
    }

    ContAction getContAction() {
        return this.currAction;
    }
}

