/*
 * Decompiled with CFR 0.152.
 */
package errorReachableAnalyzer;

import errorReachableAnalyzer.ConcurrentModel;
import errorReachableAnalyzer.Model;
import errorReachableAnalyzer.ModelInterface;
import errorReachableAnalyzer.State;
import errorReachableAnalyzer.Transition;
import java.util.ArrayList;
import java.util.List;

public class TransitionParser {
    int trNum = 0;
    ModelInterface model;
    ModelInterface controller;
    boolean isController = false;
    List<String> transitionRecordsOfModel;
    List<String> transitionRecordsOfController;
    List<String> additionalTransitionSequences;
    List<String> controllableActions;
    String transitionSequence = "";
    String crlf = System.getProperty("line.separator");
    List<String> eliminatedLabel;

    TransitionParser(Model model) {
        this.model = model;
        this.transitionRecordsOfModel = new ArrayList<String>();
    }

    TransitionParser(ModelInterface model, ModelInterface controller) {
        this.model = model;
        this.controller = controller;
    }

    private void doAllTransition(State current, String record, List<State> history) {
        if (current.toString().equals("ERROR")) {
            System.out.println(++this.trNum);
            record = String.valueOf(record) + "ERROR";
            if (this.isController) {
                this.transitionRecordsOfController.add(record);
            } else {
                this.transitionRecordsOfModel.add(record);
            }
            return;
        }
        if (history.contains(current)) {
            System.out.println(++this.trNum);
            record = String.valueOf(record) + "LOOP";
            return;
        }
        history.add(current);
        int transitionVariation = current.getToTransitionNum();
        int i = 0;
        while (i < transitionVariation) {
            Transition t = current.getToTransition(i);
            this.doAllTransition(t.getTo(), String.valueOf(record) + t.toString() + this.crlf, new ArrayList<State>(history));
            ++i;
        }
    }

    void setEliminatedLabel(List<String> eliminatedLabel) {
        this.eliminatedLabel = eliminatedLabel;
    }

    boolean checkModelSimulateController(List<String> eLabel) {
        this.setEliminatedLabel(eLabel);
        return this.checkSimulate(this.transitionRecordsOfController, this.model);
    }

    boolean checkErrorSequensesSimulateController(List<String> s) {
        ArrayList<String> ss = new ArrayList<String>();
        int i = 0;
        while (i < s.size()) {
            String[] seq = s.get(i).split(this.crlf);
            String b = this.additionalTransitionSequences.get(this.additionalTransitionSequences.size() - 1);
            int c = seq.length - 1;
            String a = seq[c];
            while (!a.equals(b)) {
                System.out.println(a);
                a = seq[--c];
            }
            String sWithoutError = "";
            int j = 0;
            while (j < c) {
                sWithoutError = String.valueOf(sWithoutError) + seq[j] + this.crlf;
                ++j;
            }
            System.out.println(sWithoutError);
            ss.add(sWithoutError);
            ++i;
        }
        this.setEliminatedLabel(new ArrayList<String>());
        return this.checkSimulate(ss, this.controller);
    }

    boolean checkSimulate(List<String> transitionSequenses, ModelInterface model) {
        boolean isSimulateWithNoError = true;
        State current = model.getInitState();
        int i = 0;
        while (i < transitionSequenses.size()) {
            String[] tr = transitionSequenses.get(i).split(this.crlf);
            int j = 0;
            while (j < tr.length) {
                if (!tr[j].equals("ERROR") && !tr[j].equals("LOOP")) {
                    if (current.containsToTransition(tr[j])) {
                        System.out.println("Choise of actions (controller's one is:" + tr[j] + ")");
                        int k = 0;
                        while (k < current.getToTransitionNum()) {
                            System.out.println(String.valueOf(i) + ":" + current.toString() + ":" + current.getToTransition(k).toString() + ":" + current.getToTransition(k).getTo().toString());
                            if (current.getToTransition(k).getTo().toString().equals("ERROR")) {
                                System.out.println("==============Caution!! This is ERROR state==============");
                                isSimulateWithNoError = false;
                            }
                            ++k;
                        }
                        current = current.getToStateByTransition(tr[j]);
                    } else if (!this.eliminatedLabel.contains(tr[j].toString())) {
                        System.out.println("in" + current.toString() + ",There are no transition by:" + tr[j].toString());
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return isSimulateWithNoError;
    }

    void startAllTransitionOfModel() {
        this.transitionRecordsOfModel = new ArrayList<String>();
        this.isController = false;
        this.doAllTransition(this.model.getInitState(), "", new ArrayList<State>());
    }

    void startAllTransitionOfController() {
        this.transitionRecordsOfController = new ArrayList<String>();
        this.isController = true;
        this.doAllTransition(this.controller.getInitState(), "", new ArrayList<State>());
    }

    List<String> getTransitionRecords() {
        this.startAllTransitionOfModel();
        return this.transitionRecordsOfModel;
    }

    String toAdditionalTransitionSequences() {
        String a = "";
        int i = 0;
        while (i < this.additionalTransitionSequences.size()) {
            a = String.valueOf(a) + this.additionalTransitionSequences.get(i) + this.crlf;
            ++i;
        }
        return a.trim();
    }

    void setAdditionaltransitionSequences(List<String> ts) {
        this.additionalTransitionSequences = ts;
    }

    boolean checkContainingSequences(String target) {
        return target.contains(this.toAdditionalTransitionSequences());
    }

    String getTransitionSeqence() {
        return this.transitionSequence;
    }

    void setModel(Model model) {
        this.model = model;
    }

    void setControllableActions(List<String> c) {
        this.controllableActions = c;
    }

    void pasteController(List<String> l) {
        this.setEliminatedLabel(l);
        this.pasteCToState(this.controller.getInitState(), this.model.getInitState());
    }

    void pasteController() {
        this.setEliminatedLabel(new ArrayList<String>());
        this.pasteCToState(this.controller.getInitState(), this.model.getInitState());
    }

    void pasteCToState(State c, State m) {
        if (c.isController() || m.toString().equals("ERROR")) {
            return;
        }
        c.setIsController();
        m.setIsController();
        int i = 0;
        while (i < c.getToTransitionNum()) {
            if (this.eliminatedLabel.contains(c.getToTransition(i).toString())) {
                this.pasteCToState(c.getToTransition(i).getTo(), m);
            } else {
                this.pasteCToTransition(c.getToTransition(i), m.getToTransition(c.getToTransition(i).toString()));
            }
            ++i;
        }
    }

    void pasteCToTransition(Transition c, Transition m) {
        if (c.isController()) {
            return;
        }
        c.setIsController();
        m.setIsController();
        if (!c.toString().equals(m.toString())) {
            System.out.println("ERROR");
        }
        this.pasteCToState(c.getTo(), m.getTo());
    }

    void eraseConttoller() {
        Model m = (Model)this.controller;
        int i = 0;
        while (i < m.getSize()) {
            State s = m.getState(i);
            s.eraseIsController();
            int j = 0;
            while (j < s.getFromTransitionNum()) {
                s.getFromTransition(j).eraseIsController();
                ++j;
            }
            j = 0;
            while (j < s.getToTransitionNum()) {
                s.getToTransition(j).eraseIsController();
                ++j;
            }
            ++i;
        }
    }

    void eraseDead() {
        State er = this.model.getErrorState();
        er.eraseIsDead();
        int i = 0;
        while (i < er.getFromTransitionNum()) {
            this.eraseDFromTransition(er.getFromTransition(i));
            ++i;
        }
    }

    private void eraseDFromTransition(Transition t) {
        if (!t.isDead()) {
            return;
        }
        t.eraseDead();
        this.eraseDFromState(t.getFrom());
    }

    private void eraseDFromState(State s) {
        if (!s.isDead()) {
            return;
        }
        s.eraseIsDead();
        int i = 0;
        while (i < s.getFromTransitionNum()) {
            if (s.getFromTransition(i).isDead()) {
                this.eraseDFromTransition(s.getFromTransition(i));
            }
            ++i;
        }
    }

    void pasteDead() {
        State er = this.model.getErrorState();
        er.setIsDead();
        int i = 0;
        while (i < er.getFromTransitionNum()) {
            this.pasteDToTransition(er.getFromTransition(i));
            ++i;
        }
    }

    void pasteUpdatedDead() {
        List<Transition> l = this.model.getUpdatedPart();
        int i = 0;
        while (i < l.size()) {
            if (l.get(i).getTo().isDead()) {
                this.pasteDToTransition(l.get(i));
            }
            ++i;
        }
    }

    void pasteDToTransition(Transition m) {
        if (m.isDead()) {
            return;
        }
        m.setIsDead();
        this.pasteDToState(m.getFrom());
    }

    void pasteDToState(State m) {
        if (m.isDead()) {
            return;
        }
        boolean dead = true;
        int i = 0;
        while (i < m.getToTransitionNum()) {
            Transition t = m.getToTransition(i);
            if (!t.isControllable() && t.isDead()) {
                m.setIsDead();
                int j = 0;
                while (j < m.getFromTransitionNum()) {
                    this.pasteDToTransition(m.getFromTransition(j));
                    ++j;
                }
                return;
            }
            if (!t.isDead()) {
                dead = false;
            }
            ++i;
        }
        if (dead) {
            m.setIsDead();
        }
        if (m.isDead()) {
            i = 0;
            while (i < m.getFromTransitionNum()) {
                this.pasteDToTransition(m.getFromTransition(i));
                ++i;
            }
        }
    }

    void checkCanSimulate(ConcurrentModel rs) {
        boolean isDead = false;
        int i = 0;
        while (i < rs.getSize()) {
            State s = rs.getState(i);
            if (s.isController() && s.isDead()) {
                isDead = true;
                System.out.println("controller cannot be generated:" + s);
                return;
            }
            ++i;
        }
        if (!isDead) {
            System.out.println("controller can be generated");
        }
    }
}

