/*
 * Decompiled with CFR 0.152.
 */
package errorReachableAnalyzer;

import errorReachableAnalyzer.Model;
import errorReachableAnalyzer.State;
import errorReachableAnalyzer.Transition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransitionFileReader {
    BufferedReader reader;
    String rawData;
    String crlf = System.getProperty("line.separator");
    List<String> controllableActions;
    HashMap<String, State> stateMap;

    TransitionFileReader(File target) {
        try {
            this.reader = new BufferedReader(new FileReader(target));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.controllableActions = new ArrayList<String>();
    }

    void readModelFile() {
        this.rawData = "";
        try {
            String buf;
            long start = System.currentTimeMillis();
            while ((buf = this.reader.readLine()) != null) {
                this.rawData = String.valueOf(this.rawData) + buf.replace('\t', ' ');
            }
            long stop = System.currentTimeMillis();
            System.out.println("readModelFile:" + (stop - start));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void setControllableActions(List<String> s) {
        this.controllableActions = s;
    }

    List<String> readTransitionSequenceFileFromLTSA() {
        this.rawData = "";
        ArrayList<String> ltsa = new ArrayList<String>();
        try {
            String buf;
            while ((buf = this.reader.readLine()) != null) {
                this.rawData = String.valueOf(this.rawData) + buf.split("AT.")[0].trim() + this.crlf;
            }
            this.rawData = String.valueOf(this.rawData) + "ERROR" + this.crlf;
            System.out.println(this.rawData);
            ltsa.add(this.rawData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ltsa;
    }

    String getRawData() {
        return this.rawData;
    }

    Model getModel() {
        State er;
        this.readModelFile();
        long start = System.currentTimeMillis();
        Model m = null;
        String[] transitionDatas = this.rawData.split("Q0,")[1].split("\\),");
        State[] stateMaterials = new State[transitionDatas.length + 1];
        this.stateMap = new HashMap();
        String[] transitionMaterials = new String[transitionDatas.length];
        int i = 0;
        while (i < transitionDatas.length) {
            String[] buf = transitionDatas[i].split("\\=");
            stateMaterials[i] = new State(buf[0].trim());
            this.stateMap.put(buf[0].trim(), stateMaterials[i]);
            if (buf[1].indexOf("(") != -1) {
                transitionMaterials[i] = buf[1].indexOf(")") != -1 ? buf[1].substring(buf[1].indexOf("(") + 1, buf[1].indexOf(")")) : buf[1].substring(buf[1].indexOf("(") + 1);
            }
            ++i;
        }
        stateMaterials[transitionDatas.length] = er = new State("ERROR");
        this.stateMap.put("ERROR", er);
        int i2 = 0;
        while (i2 < transitionDatas.length) {
            if (transitionMaterials[i2].indexOf("|") == -1) {
                this.translateToTransition(transitionMaterials[i2], stateMaterials[i2]);
            } else {
                String[] t = transitionMaterials[i2].split("\\|");
                int j = 0;
                while (j < t.length) {
                    if (t[j].indexOf("->") != -1) {
                        this.translateToTransition(t[j], stateMaterials[i2]);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        m = new Model(stateMaterials, this.stateMap);
        long stop = System.currentTimeMillis();
        System.out.println("making Model:" + (stop - start));
        return m;
    }

    private void translateToTransition(String transitionmaterial, State s) {
        String[] ts = transitionmaterial.split("->");
        if (ts[0].contains("{")) {
            List<String> tList = TransitionFileReader.splitTransition(ts[0].trim());
            int i = 0;
            while (i < tList.size()) {
                this.makeTransition(tList.get(i), ts[1], s);
                ++i;
            }
        } else {
            this.makeTransition(ts[0], ts[1], s);
        }
    }

    private void makeTransition(String transitionmaterial, String toStateName, State s) {
        Transition tr = new Transition(transitionmaterial.trim(), s, this.stateMap.get(toStateName.trim()));
        if (this.controllableActions.contains(tr.toString())) {
            tr.setIsControllable();
        }
        s.addToTransition(tr);
        this.stateMap.get(toStateName.trim()).addFromTransition(tr);
    }

    static List<String> splitTransition(String base) {
        ArrayList<String> temp = new ArrayList<String>();
        if (base.indexOf(".") < base.indexOf("{") && base.indexOf(".") != -1) {
            String b = base.substring(0, base.indexOf(".") + 1).trim();
            String[] var = base.substring(base.indexOf("{") + 1, base.indexOf("}")).split(",");
            int i = 0;
            while (i < var.length) {
                temp.add(String.valueOf(b) + var[i].trim());
                ++i;
            }
        } else {
            String a = base.substring(base.indexOf("{") + 1, base.lastIndexOf("}"));
            while (a.contains(",")) {
                int i;
                Object t;
                if (a.contains("}.{")) {
                    t = a.split("\\}\\.\\{");
                    String[] front = t[0].substring(t[0].indexOf("{") + 1).split(",");
                    String[] back = t[1].substring(0, t[1].indexOf("}")).split(",");
                    i = 0;
                    while (i < front.length) {
                        int j = 0;
                        while (j < back.length) {
                            temp.add(String.valueOf(front[i].trim()) + "." + back[j].trim());
                            ++j;
                        }
                        ++i;
                    }
                    a = a.substring(a.indexOf("},") + 2);
                    continue;
                }
                t = a.substring(0, a.indexOf(","));
                if (a.indexOf("{") < a.indexOf(",") && a.indexOf("{") != -1) {
                    t = a.substring(0, a.indexOf("}"));
                    String b = ((String)t).substring(0, ((String)t).indexOf(".") + 1).trim();
                    String[] var = ((String)t).substring(((String)t).indexOf("{") + 1).split(",");
                    i = 0;
                    while (i < var.length) {
                        temp.add(String.valueOf(b) + var[i].trim());
                        ++i;
                    }
                    if ((a = a.substring(a.indexOf("}") + 1)).indexOf(",") != 0) continue;
                    a = a.substring(a.indexOf(",") + 1);
                    continue;
                }
                temp.add(a.substring(0, a.indexOf(",")));
                a = a.substring(a.indexOf(",") + 1);
            }
        }
        return temp;
    }
}

