/*
 * Decompiled with CFR 0.152.
 */
package errorReachableAnalyzer;

import errorReachableAnalyzer.ConcurrentModel;
import errorReachableAnalyzer.ConcurrentState;
import errorReachableAnalyzer.ConcurrentSystemModelMaker;
import errorReachableAnalyzer.Model;
import errorReachableAnalyzer.RuntimeSet;
import errorReachableAnalyzer.State;
import errorReachableAnalyzer.TransitionFileReader;
import errorReachableAnalyzer.TransitionParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Test {
    Model c;
    Model m;
    Model r;
    List<String> errorList;
    List<String> slist;
    List<String> targetList;
    TransitionParser tp;

    public static void main(String[] args) {
        Test t = new Test();
        long start = System.currentTimeMillis();
        t.runtimeExecute();
        long end = System.currentTimeMillis();
        System.out.println("time:" + (end - start) + "ms");
    }

    void readModelInteractive() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("input transition Model file:");
            TransitionFileReader reader = new TransitionFileReader(new File(r.readLine()));
            this.m = reader.getModel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void readControllerInteractive() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("input transition Controller file:");
            TransitionFileReader reader = new TransitionFileReader(new File(r.readLine()));
            this.c = reader.getModel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void readEliminatedLabel() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        this.errorList = new ArrayList<String>();
        System.out.println("input eliminated label:");
        try {
            String buf;
            while (!(buf = r.readLine()).equals("")) {
                this.errorList.add(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void readContainedActionSequence() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        this.slist = new ArrayList<String>();
        System.out.println("input contained action sequence:");
        try {
            String buf;
            while (!(buf = r.readLine()).equals("")) {
                this.slist.add(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void displayModelAuto() {
        this.displayModelAuto(false);
    }

    void checkControllerAndDead() {
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("move.e");
        ca.add("move.w");
        ca.add("putdown");
        ca.add("pickup");
        ca.add("ended");
        ca.add("reset");
        ca.add("{move.{e, w}, {pickup, putdown}}");
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\extremeExample.txt"));
        reader.setControllableActions(ca);
        long start = System.currentTimeMillis();
        this.m = reader.getModel();
        long stop = System.currentTimeMillis();
        System.out.println("preparing Model:" + (stop - start));
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller2.txt"));
        this.slist = new ArrayList<String>();
        this.slist.add("ended");
        this.slist.add("reset");
        this.c = reader.getModel();
        start = System.currentTimeMillis();
        System.out.println("preparing model:" + (start - stop));
        TransitionParser tp = new TransitionParser(this.m, this.c);
        stop = System.currentTimeMillis();
        tp.pasteController(this.slist);
        start = System.currentTimeMillis();
        System.out.println("paste to controller:" + (start - stop));
        tp.pasteDead();
        stop = System.currentTimeMillis();
        System.out.println("pate to dead:" + (stop - start));
        int i = 0;
        while (i < this.m.getSize()) {
            State s = this.m.getState(i);
            if (s.isController() && s.isDead()) {
                System.out.println("controller cannot be generated");
                return;
            }
            ++i;
        }
        System.out.println("controller can be generated");
    }

    void displayModelAuto(boolean onlyController) {
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("move.e");
        ca.add("move.w");
        ca.add("putdown");
        ca.add("pickup");
        ca.add("ended");
        ca.add("reset");
        ca.add("{move.{e, w}, {pickup, putdown}}");
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Time_EEW.txt"));
        reader.setControllableActions(ca);
        this.m = reader.getModel();
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller.txt"));
        this.slist = new ArrayList<String>();
        this.c = reader.getModel();
        TransitionParser tp = new TransitionParser(this.m, this.c);
        tp.pasteController(this.slist);
        tp.pasteDead();
        int i = 0;
        while (i < this.m.getSize()) {
            State s = this.m.getState(i);
            if (!onlyController || s.isController()) {
                System.out.println(s + ":isDead " + s.isDead());
                System.out.println("ToTransition");
                int j = 0;
                while (j < s.getToTransitionNum()) {
                    if (!onlyController || s.getToTransition(j).isController()) {
                        System.out.println(" " + s.getToTransition(j) + ":isControllable " + s.getToTransition(j).isControllable() + " isDead " + s.getToTransition(j).isDead());
                    }
                    ++j;
                }
                System.out.println("FromTransition");
                j = 0;
                while (j < s.getFromTransitionNum()) {
                    if (!onlyController || s.getFromTransition(j).isController()) {
                        System.out.println(" " + s.getFromTransition(j) + ":isControllable " + s.getFromTransition(j).isControllable() + " isDead " + s.getFromTransition(j).isDead());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void checkSimulateInteractively() {
        this.readControllerInteractive();
        this.readModelInteractive();
        this.tp = new TransitionParser(this.m, this.c);
        this.readContainedActionSequence();
        this.tp.setAdditionaltransitionSequences(this.slist);
        List<String> records = this.tp.getTransitionRecords();
        this.targetList = new ArrayList<String>();
        int i = 0;
        while (i < records.size()) {
            if (records.get(i).contains("ERROR") && this.tp.checkContainingSequences(records.get(i))) {
                System.out.println("=========" + i + "=========");
                System.out.println(records.get(i));
                System.out.println("========================");
                this.targetList.add(records.get(i));
            }
            ++i;
        }
        System.out.println(this.tp.checkErrorSequensesSimulateController(this.targetList));
    }

    void checkSimulateAuto() {
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\DONTPUT_EEW.txt"));
        this.m = reader.getModel();
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller.txt"));
        this.c = reader.getModel();
        this.tp = new TransitionParser(this.m, this.c);
        this.slist = new ArrayList<String>();
        this.slist.add("arrive.e");
        this.slist.add("move.w");
        this.slist.add("arrive.e");
        this.tp.setAdditionaltransitionSequences(this.slist);
        List<String> records = this.tp.getTransitionRecords();
        this.targetList = new ArrayList<String>();
        int i = 0;
        while (i < records.size()) {
            if (records.get(i).contains("ERROR") && this.tp.checkContainingSequences(records.get(i))) {
                System.out.println("=========" + i + "=========");
                System.out.println(records.get(i));
                System.out.println("========================");
                this.targetList.add(records.get(i));
            }
            ++i;
        }
        System.out.println(this.tp.checkErrorSequensesSimulateController(this.targetList));
    }

    void checkErrorSeuenceSimCon() {
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller.txt"));
        this.c = reader.getModel();
        this.tp = new TransitionParser(null, this.c);
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\a.txt"));
        this.slist = new ArrayList<String>();
        this.slist.add("arrive.e");
        this.slist.add("move.w");
        this.slist.add("arrive.e");
        this.tp.setAdditionaltransitionSequences(this.slist);
        this.targetList = reader.readTransitionSequenceFileFromLTSA();
        System.out.println(this.tp.checkErrorSequensesSimulateController(this.targetList));
    }

    void compose() {
        long start = System.currentTimeMillis();
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("move.e");
        ca.add("move.w");
        ca.add("putdown");
        ca.add("pickup");
        ca.add("ended");
        ca.add("reset");
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Map.txt"));
        this.m = reader.getModel();
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ReqMoni.txt"));
        this.r = reader.getModel();
        ConcurrentSystemModelMaker.setControllableAction(ca);
        ConcurrentModel cm = ConcurrentSystemModelMaker.makeConccurentSystem(this.m, this.r);
        long stop = System.currentTimeMillis();
        System.out.println("Time of Making concurrent system:" + (stop - start));
        System.out.println("states:" + cm.getSize());
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller.txt"));
        this.c = reader.getModel();
        this.slist = new ArrayList<String>();
        start = System.currentTimeMillis();
        System.out.println("time for making controller model:" + (start - stop));
        ConcurrentModel cm2 = ConcurrentSystemModelMaker.modelUpdate(cm, this.m, this.r, "Q3", "arrive.e", "Q7");
        this.tp = new TransitionParser(cm2, this.c);
        this.slist = new ArrayList<String>();
        this.tp.pasteDead();
        this.tp.pasteController(this.slist);
        int i = 0;
        while (i < cm2.getSize()) {
            State s = cm2.getState(i);
            if (s.isController() && s.isDead()) {
                System.out.println("controller cannot be generated:" + s);
                stop = System.currentTimeMillis();
                System.out.println("update and analyze:" + (stop - start) + "ms");
                return;
            }
            ++i;
        }
        System.out.println("controller can be generated");
        stop = System.currentTimeMillis();
        System.out.println("update and analyze:" + (stop - start) + "ms");
        this.tp.eraseDead();
        ConcurrentModel cm3 = ConcurrentSystemModelMaker.modelUpdate(cm2, this.m, this.r, "Q8", "arrive.e", "Q7");
        this.tp = new TransitionParser(cm3, this.c);
        this.slist = new ArrayList<String>();
        this.tp.pasteDead();
        this.tp.pasteController(this.slist);
        int i2 = 0;
        while (i2 < cm3.getSize()) {
            State s = cm3.getState(i2);
            if (s.isController() && s.isDead()) {
                System.out.println("controller cannot be generated:" + s);
                stop = System.currentTimeMillis();
                System.out.println("update and analyze:" + (stop - start) + "ms");
                return;
            }
            ++i2;
        }
        System.out.println("controller can be generated");
    }

    void productCell() {
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ProductCell_Map.txt"));
        this.m = reader.getModel();
        ArrayList<Model> moniSet = new ArrayList<Model>();
        moniSet.add(new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ProductCell_Req.txt")).getModel());
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("moveTo.tray");
        ca.add("moveTo.oven");
        ca.add("moveTo.drill");
        ca.add("putdown");
        ca.add("pickup");
        ca.add("readTag");
        ca.add("bake");
        ca.add("drill");
        ca.add("reset");
        ConcurrentSystemModelMaker.setControllableAction(ca);
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ProductCell_Cont.txt"));
        this.c = reader.getModel();
        RuntimeSet rs = new RuntimeSet(this.m, moniSet);
        long start = System.currentTimeMillis();
        this.checkSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        long stop = System.currentTimeMillis();
        System.out.println("1,Time:" + (stop - start));
    }

    void runtimeExecute() {
        boolean isDead = false;
        TransitionFileReader reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Map.txt"));
        this.m = reader.getModel();
        ArrayList<Model> moniSet = new ArrayList<Model>();
        moniSet.add(new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ReqMoni_TIRE1.txt")).getModel());
        moniSet.add(new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ReqMoni_TIRE2.txt")).getModel());
        moniSet.add(new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\ReqMoni_TIRE3.txt")).getModel());
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("move.e");
        ca.add("move.w");
        ca.add("putdown");
        ca.add("pickup");
        ca.add("ended");
        ca.add("reset");
        ConcurrentSystemModelMaker.setControllableAction(ca);
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller.txt"));
        this.c = reader.getModel();
        RuntimeSet rs = new RuntimeSet(this.m, moniSet);
        long start = System.currentTimeMillis();
        this.checkSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        long stop = System.currentTimeMillis();
        System.out.println("1,Time:" + (stop - start));
        rs.concurrentSystemUpdate("Q3", "arrive.e", "Q7");
        this.tp = new TransitionParser(rs.getConcurrentSystem(), this.c);
        this.checkUpdatedSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        start = System.currentTimeMillis();
        System.out.println("2,Time:" + (start - stop));
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller3_wee.txt"));
        this.c = reader.getModel();
        this.tp = new TransitionParser(rs.getConcurrentSystem(), this.c);
        this.checkSimulate(this.tp, rs.getConcurrentSystem());
        start = System.currentTimeMillis();
        rs.concurrentSystemUpdate("Q6", "arrive.m", "Q4");
        this.checkUpdatedSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        stop = System.currentTimeMillis();
        System.out.println("3,Time:" + (stop - start));
        rs.degradation();
        rs.reCompose();
        this.checkSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        stop = System.currentTimeMillis();
        System.out.println("4,Time:" + (stop - start));
        reader = new TransitionFileReader(new File("C:\\Users\\zawawa\\Desktop\\JIT_Deg\\Controller2_wee_mem.txt"));
        this.c = reader.getModel();
        stop = System.currentTimeMillis();
        rs.concurrentSystemUpdate("Q8", "arrive.e", "Q7");
        this.checkUpdatedSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        start = System.currentTimeMillis();
        System.out.println("5,Time:" + (start - stop));
        rs.degradation();
        rs.reCompose();
        this.checkSimulate(new TransitionParser(rs.getConcurrentSystem(), this.c), rs.getConcurrentSystem());
        stop = System.currentTimeMillis();
        System.out.println("6,Time:" + (stop - start));
    }

    void checkSimulate(TransitionParser tp, ConcurrentModel rs) {
        tp.eraseDead();
        tp.eraseConttoller();
        tp.pasteDead();
        tp.pasteController();
        tp.checkCanSimulate(rs);
    }

    void checkUpdatedSimulate(TransitionParser tp, ConcurrentModel rs) {
        tp.pasteUpdatedDead();
        tp.checkCanSimulate(rs);
    }

    void displayModel(ConcurrentModel m) {
        int i = 0;
        while (i < m.getSize()) {
            ConcurrentState s = m.getConcurrentState(i);
            System.out.println(s + ",C:" + s.isController() + ",D:" + s.isDead());
            System.out.println("From:");
            int j = 0;
            while (j < s.getFromTransitionNum()) {
                System.out.println(s.getFromTransition(j).getFrom() + "->" + s.getFromTransition(j));
                ++j;
            }
            System.out.println("To:");
            j = 0;
            while (j < s.getToTransitionNum()) {
                System.out.println(s.getToTransition(j) + "->" + s.getToTransition(j).getTo());
                ++j;
            }
            ++i;
        }
    }

    void displayModel(Model m) {
        int i = 0;
        while (i < m.getSize()) {
            State s = m.getState(i);
            System.out.println(s + ",C:" + s.isController() + ",D:" + s.isDead());
            System.out.println("From:");
            int j = 0;
            while (j < s.getFromTransitionNum()) {
                System.out.println(s.getFromTransition(j).getFrom() + "->" + s.getFromTransition(j));
                ++j;
            }
            System.out.println("To:");
            j = 0;
            while (j < s.getToTransitionNum()) {
                System.out.println(s.getToTransition(j) + "->" + s.getToTransition(j).getTo());
                ++j;
            }
            ++i;
        }
    }
}

