/*
 * Decompiled with CFR 0.152.
 */
package errorReachableAnalyzer;

import errorReachableAnalyzer.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class State {
    protected String name;
    private HashMap<String, Transition> toTransition;
    private List<String> toTransitionNameList;
    private List<Transition> fromTransitionList;
    private boolean isController;
    protected boolean isDead;

    State(String name) {
        this.name = name;
        this.toTransition = new HashMap();
        this.toTransitionNameList = new ArrayList<String>();
        this.fromTransitionList = new ArrayList<Transition>();
        this.isController = false;
        this.isDead = false;
    }

    void addToTransition(Transition tr) {
        this.toTransition.put(tr.toString(), tr);
        this.toTransitionNameList.add(tr.toString());
    }

    void eraseIsController() {
        this.isController = false;
    }

    void setIsController() {
        this.isController = true;
    }

    void setIsDead() {
        this.isDead = true;
    }

    void eraseIsDead() {
        this.isDead = false;
    }

    boolean isController() {
        return this.isController;
    }

    boolean isDead() {
        return this.isDead;
    }

    void addFromTransition(Transition tr) {
        this.fromTransitionList.add(tr);
    }

    boolean containsToTransition(String name) {
        return this.toTransitionNameList.contains(name);
    }

    State getToStateByTransition(String tr) {
        return this.toTransition.get(tr).getTo();
    }

    Boolean hasToTransitions() {
        return !this.toTransition.isEmpty();
    }

    int getToTransitionNum() {
        return this.toTransitionNameList.size();
    }

    Transition getToTransition(int i) {
        return this.toTransition.get(this.toTransitionNameList.get(i));
    }

    Transition getToTransition(String name) {
        return this.toTransition.get(name);
    }

    int getFromTransitionNum() {
        return this.fromTransitionList.size();
    }

    Transition getFromTransition(int i) {
        return this.fromTransitionList.get(i);
    }

    public String toString() {
        return this.name;
    }
}

