/*
 * Decompiled with CFR 0.152.
 */
package errorReachableAnalyzer;

import errorReachableAnalyzer.ConcurrentModel;
import errorReachableAnalyzer.ConcurrentSystemModelMaker;
import errorReachableAnalyzer.Model;
import java.util.ArrayList;
import java.util.List;

public class RuntimeSet {
    private Model currentEnv;
    private Model currentMonitor;
    private List<Model> monitorSet;
    private int level;
    private ConcurrentModel concurrentSystem;
    private List<String> updateRecord;

    public RuntimeSet(Model currentEnv, Model currentMonitor) {
        this.currentEnv = currentEnv;
        this.currentMonitor = currentMonitor;
        this.concurrentSystem = ConcurrentSystemModelMaker.makeConccurentSystem(currentEnv, currentMonitor);
        this.updateRecord = new ArrayList<String>();
    }

    public RuntimeSet(Model currentEnv, List<Model> monitorSet) {
        this.currentEnv = currentEnv;
        this.monitorSet = monitorSet;
        this.currentMonitor = monitorSet.get(monitorSet.size() - 1);
        this.level = monitorSet.size() - 1;
        this.concurrentSystem = ConcurrentSystemModelMaker.makeConccurentSystem(currentEnv, this.currentMonitor);
        this.updateRecord = new ArrayList<String>();
    }

    public void degradation() {
        --this.level;
        this.currentMonitor = this.monitorSet.get(this.level);
    }

    public int getCurrentLevel() {
        return this.level;
    }

    void setCurrentEnv(Model currentEnv) {
        this.currentEnv = currentEnv;
    }

    void setCurrentMonitor(Model currentMonitor) {
        this.currentMonitor = currentMonitor;
    }

    void setConcurrentSystem(ConcurrentModel concurrentSystem) {
        this.concurrentSystem = concurrentSystem;
    }

    void envUpdate(String from, String t, String to) {
        this.currentEnv = ConcurrentSystemModelMaker.attachTransition(this.currentEnv, from, t, to);
    }

    void concurrentSystemUpdate(String from, String t, String to) {
        this.concurrentSystem = ConcurrentSystemModelMaker.modelUpdate(this.concurrentSystem, this.currentEnv, this.currentMonitor, from, t, to);
        this.updateRecord.add(String.valueOf(from) + "," + t + "," + to);
    }

    void reCompose() {
        this.concurrentSystem = ConcurrentSystemModelMaker.makeConccurentSystem(this.currentEnv, this.currentMonitor);
    }

    public ConcurrentModel getConcurrentSystem() {
        return this.concurrentSystem;
    }

    public Model getCurrentEnv() {
        return this.currentEnv;
    }

    public Model getCurrentMonitor() {
        return this.currentMonitor;
    }
}

