import java.net.*;
import java.io.*;
import com.illposed.osc.*;
public class TestClientOsc {
	private ServerSocket ss=null;
	private Socket clientSocket=null;
	private OSCPortIn receiver = null;
	private PrintStream buf=null;	
	
	public static void main(String[]a){
		TestClientOsc tco=new TestClientOsc();
		System.out.println("start");

		tco.makeServerSocket(8000);
		tco.acceptClientSocket();
		try {
			tco.receiver = new OSCPortIn(9999);
			tco.receiver.addListener("/sayhello", tco.makeListener());			
			tco.receiver.startListening();
			
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		};
		
		while(true){
			tco.acceptClientSocket();
			System.out.println("stop");				
		}	
	}
	private OSCListener makeListener(){
		return new OSCListener() {
			public void acceptMessage(java.util.Date time, OSCMessage message) {
				float x,y,z;
				String[] buffer;
				String ob; 
				ob=(String)message.getArguments()[0];
				buffer=ob.split(" ");
				ob =buffer[0]+","+buffer[1]+","+buffer[2];
				System.out.println(ob);
				if(clientSocket.isBound()){
					buf.print(ob);
				}else{System.out.println("socket is collapted");}
			}
		};
	}
	public void makeServerSocket(int port){
		try{
			ss=new ServerSocket(port);
		}catch(IOException e){
			e.printStackTrace();
		}
	}
	public void acceptClientSocket(){
		try {
			System.out.println("wait");
			clientSocket=ss.accept();
			buf =new PrintStream(clientSocket.getOutputStream());
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
			
		}
	}
}