import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
public class PositionMap extends JFrame{
	float x=0;
	float y=0;
	float edgeX;
	float edgeY;
	int size=300;
	int width=(int)(edgeX*size);
	int height =(int)(edgeY*size);
	JPanel panel;
	
	public static void main(String[] args){
		PositionMap pm=new PositionMap("PositionMap");
	}
	
	public PositionMap(String name){
		super(name);
		panel=(JPanel)getContentPane();
		panel.addMouseMotionListener(new MouseMotionCheck());
		edgeX=(float)0.6;edgeY=(float)1.8;
		width=(int)(edgeX*size);
		height =(int)(edgeY*size);
		addKeyListener(new KeyCommand());
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(width, height);
		setVisible(true);

	}
	public PositionMap(String name,float edx,float edy){
		super(name);
		panel=(JPanel)getContentPane();
		panel.addMouseMotionListener(new MouseMotionCheck());
		edgeX=edx;edgeY=edy;
		width=(int)(edgeX*size);
		height =(int)(edgeY*size);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(width, height);
	}
	
	public float getXPosition(){
		return x;
	}
	public float getYPosition(){
		return y;
	}
	class MouseMotionCheck implements MouseMotionListener{

		@Override
		public void mouseDragged(MouseEvent e) {
			// TODO Auto-generated method stub
			x=e.getX();
			y=e.getY();
			x=(float) (x/300-0.3);
			y=(float)(1.8-y/300);
			//System.out.println("}EXhbO܂@ʒux"+x+"y="+y);
			System.out.println(x+","+y);
			
		}
		@Override
		public void mouseMoved(MouseEvent e) {
		/*	// TODO Auto-generated method stub
			int x=e.getX();
			int y=e.getY();
			System.out.println("}EX܂@ʒux"+x+"y="+y);
		//*/	
		}	
	}
	class KeyCommand implements KeyListener{

		@Override
		public void keyPressed(KeyEvent e) {
			// TODO Auto-generated method stub
			System.out.println("press");
			check(e);
		}

		@Override
		public void keyReleased(KeyEvent e) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void keyTyped(KeyEvent e) {
			// TODO Auto-generated method stub
			
		}
		void check(KeyEvent e){
			int keyCode=e.getKeyCode();
			switch(keyCode){
			case KeyEvent.VK_UP:
				y=(float)(y+0.05);
				repaint();
				break;
			case KeyEvent.VK_DOWN:
				y=(float)(y-0.05);
				repaint();
				break;
			case KeyEvent.VK_RIGHT:
				x=(float)(x+0.05);
				repaint();
				break;
			case KeyEvent.VK_LEFT:
				x=(float)(x-0.05);
				repaint();
			}
		}
		
		
	}
	@Override
	public void paint(Graphics g){
		int mapX=(int)(size*(x+edgeX/2));
		int mapY=(int)(size*(edgeY-y));
		int sweeperwidth=20;
		int fx=mapX-sweeperwidth/2;
		int fy=mapY-sweeperwidth/2;
		g.clearRect(0, 0, width, height);
		
		g.setColor(Color.black);
		g.fillRect((int)(size*(edgeX/2-0.3)), (int)(size*(edgeY-1.8)), (int)(size*0.6), (int)(size*1.8));
		g.clearRect((int)(size*(edgeX/2-0.3)+10), (int)(size*(edgeY-1.8)+10), (int)(size*0.6-20), (int)(size*1.8-20));
		g.fillRect(fx, fy, sweeperwidth,sweeperwidth);
		System.out.println(fx+","+fy);
		
		
	}
}
