/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.ui;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.OSCPortOut;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OscUI
extends JPanel {
    protected JFrame parent;
    protected JTextField addressWidget;
    protected JTextField portWidget;
    protected JTextField textBox;
    protected JTextField textBox2;
    protected JTextField textBox3;
    protected JTextField textBox4 = new JTextField(String.valueOf(1000), 8);
    protected JLabel delayLabel;
    protected JButton firstSynthButtonOn;
    protected JButton secondSynthButtonOn;
    protected JButton thirdSynthButtonOn;
    protected JButton firstSynthButtonOff;
    protected JButton secondSynthButtonOff;
    protected JButton thirdSynthButtonOff;
    protected JSlider slider;
    protected JSlider slider2;
    protected JSlider slider3;
    protected OSCPortOut oscPort;

    public OscUI(JFrame jFrame) {
        this.parent = jFrame;
        this.makeDisplay();
        try {
            this.oscPort = new OSCPortOut();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void makeDisplay() {
        this.setLayout(new BoxLayout(this, 1));
        this.addOscServerAddressPanel();
        this.addGlobalControlPanel();
        this.addFirstSynthPanel();
        this.addSecondSynthPanel();
        this.addThirdSynthPanel();
    }

    protected void addOscServerAddressPanel() {
        JPanel jPanel = this.makeNewJPanel1();
        jPanel.setBackground(new Color(123, 150, 123));
        this.addressWidget = new JTextField("localhost");
        JButton jButton = new JButton("Set Address");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.addressChanged();
            }
        });
        JLabel jLabel = new JLabel(Integer.toString(OSCPort.defaultSCOSCPort()));
        jLabel.setForeground(new Color(255, 255, 255));
        JLabel jLabel2 = new JLabel("Port");
        jLabel2.setForeground(new Color(255, 255, 255));
        jPanel.add(jButton);
        jPanel.add(this.addressWidget);
        jPanel.add(jLabel2);
        jPanel.add(jLabel);
        this.add(jPanel);
    }

    public void addGlobalControlPanel() {
        JPanel jPanel = this.makeNewJPanel();
        JButton jButton = new JButton("All Off");
        JButton jButton2 = new JButton("All On");
        this.textBox4 = new JTextField(String.valueOf(1000), 8);
        this.delayLabel = new JLabel("All Off delay in ms");
        this.delayLabel.setForeground(new Color(255, 255, 255));
        jPanel.setBackground(new Color(13, 53, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendGlobalOn(1000, 1001, 1002);
                OscUI.this.firstSynthButtonOn.setEnabled(false);
                OscUI.this.firstSynthButtonOff.setEnabled(true);
                OscUI.this.slider.setEnabled(true);
                OscUI.this.slider.setValue(2050);
                OscUI.this.textBox.setEnabled(true);
                OscUI.this.textBox.setText("440.0");
                OscUI.this.secondSynthButtonOn.setEnabled(false);
                OscUI.this.secondSynthButtonOff.setEnabled(true);
                OscUI.this.slider2.setEnabled(true);
                OscUI.this.slider2.setValue(2048);
                OscUI.this.textBox2.setEnabled(true);
                OscUI.this.textBox2.setText("440.0");
                OscUI.this.thirdSynthButtonOn.setEnabled(false);
                OscUI.this.thirdSynthButtonOff.setEnabled(true);
                OscUI.this.slider3.setEnabled(true);
                OscUI.this.slider3.setValue(2052);
                OscUI.this.textBox3.setEnabled(true);
                OscUI.this.textBox3.setText("440.0");
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendGlobalOff(1000, 1001, 1002);
                OscUI.this.firstSynthButtonOn.setEnabled(true);
                OscUI.this.firstSynthButtonOff.setEnabled(false);
                OscUI.this.slider.setEnabled(false);
                OscUI.this.slider.setValue(0);
                OscUI.this.textBox.setEnabled(false);
                OscUI.this.textBox.setText("0");
                OscUI.this.secondSynthButtonOn.setEnabled(true);
                OscUI.this.secondSynthButtonOff.setEnabled(false);
                OscUI.this.slider2.setEnabled(false);
                OscUI.this.slider2.setValue(0);
                OscUI.this.textBox2.setEnabled(false);
                OscUI.this.textBox2.setText("0");
                OscUI.this.thirdSynthButtonOn.setEnabled(true);
                OscUI.this.thirdSynthButtonOff.setEnabled(false);
                OscUI.this.slider3.setEnabled(false);
                OscUI.this.slider3.setValue(0);
                OscUI.this.textBox3.setEnabled(false);
                OscUI.this.textBox3.setText("0");
            }
        });
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.add(this.textBox4);
        jPanel.add(this.delayLabel);
        this.add(jPanel);
    }

    public void addFirstSynthPanel() {
        JPanel jPanel = this.makeNewJPanel();
        jPanel.setBackground(new Color(13, 23, 0));
        this.firstSynthButtonOn = new JButton("On");
        this.firstSynthButtonOff = new JButton("Off");
        this.firstSynthButtonOff.setEnabled(false);
        this.slider = new JSlider(0);
        this.slider.setMinimum(0);
        this.slider.setMaximum(10000);
        this.slider.setEnabled(false);
        this.textBox = new JTextField(String.valueOf(0), 8);
        this.textBox.setEnabled(false);
        this.firstSynthButtonOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOn(440.0f, 1000);
                OscUI.this.firstSynthButtonOn.setEnabled(false);
                OscUI.this.firstSynthButtonOff.setEnabled(true);
                OscUI.this.textBox.setText("440.0");
                OscUI.this.textBox.setEnabled(true);
                OscUI.this.slider.setValue(2050);
                OscUI.this.slider.setEnabled(true);
            }
        });
        this.firstSynthButtonOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOff(1000);
                OscUI.this.firstSynthButtonOn.setEnabled(true);
                OscUI.this.firstSynthButtonOff.setEnabled(false);
                OscUI.this.slider.setEnabled(false);
                OscUI.this.slider.setValue(0);
                OscUI.this.textBox.setEnabled(false);
                OscUI.this.textBox.setText("0");
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    float f = jSlider.getValue();
                    f = f / 10000.0f * (f / 10000.0f);
                    f *= 10000.0f;
                    OscUI.this.doPrintValue(f += 20.0f);
                    OscUI.this.doSendSlider(f, 1000);
                }
            }
        });
        this.textBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                float f = Float.valueOf(jTextField.getText()).floatValue();
                if (f > 10020.0f) {
                    f = 10020.0f;
                    OscUI.this.doPrintValue(f);
                }
                if (f < 20.0f) {
                    f = 20.0f;
                    OscUI.this.doPrintValue(f);
                }
                OscUI.this.slider.setValue((int)(10000.0 * Math.sqrt((f - 20.0f) / 10000.0f)));
                OscUI.this.doSendSlider(f, 1000);
            }
        });
        jPanel.add(this.firstSynthButtonOn);
        jPanel.add(this.firstSynthButtonOff);
        jPanel.add(this.slider);
        jPanel.add(this.textBox);
        this.add(jPanel);
    }

    protected void addSecondSynthPanel() {
        JPanel jPanel = this.makeNewJPanel();
        jPanel.setBackground(new Color(13, 23, 0));
        this.secondSynthButtonOn = new JButton("On");
        this.secondSynthButtonOff = new JButton("Off");
        this.secondSynthButtonOff.setEnabled(false);
        this.slider2 = new JSlider(0);
        this.slider2.setMinimum(0);
        this.slider2.setMaximum(10000);
        this.slider2.setEnabled(false);
        this.textBox2 = new JTextField(String.valueOf(0), 8);
        this.textBox2.setEnabled(false);
        this.secondSynthButtonOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOn(440.0f, 1001);
                OscUI.this.secondSynthButtonOn.setEnabled(false);
                OscUI.this.secondSynthButtonOff.setEnabled(true);
                OscUI.this.slider2.setEnabled(true);
                OscUI.this.slider2.setValue(2050);
                OscUI.this.textBox2.setEnabled(true);
                OscUI.this.textBox2.setText("440.0");
            }
        });
        this.secondSynthButtonOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOff(1001);
                OscUI.this.secondSynthButtonOn.setEnabled(true);
                OscUI.this.secondSynthButtonOff.setEnabled(false);
                OscUI.this.slider2.setEnabled(false);
                OscUI.this.slider2.setValue(0);
                OscUI.this.textBox2.setEnabled(false);
                OscUI.this.textBox2.setText("0");
            }
        });
        this.slider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    float f = jSlider.getValue();
                    f = f / 10000.0f * (f / 10000.0f);
                    f *= 10000.0f;
                    OscUI.this.doPrintValue2(f += 20.0f);
                    OscUI.this.doSendSlider(f, 1001);
                }
            }
        });
        this.textBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                float f = Float.valueOf(jTextField.getText()).floatValue();
                if (f > 10020.0f) {
                    f = 10020.0f;
                    OscUI.this.doPrintValue2(f);
                }
                if (f < 20.0f) {
                    f = 20.0f;
                    OscUI.this.doPrintValue2(f);
                }
                OscUI.this.slider2.setValue((int)(10000.0 * Math.sqrt((f - 20.0f) / 10000.0f)));
                OscUI.this.doSendSlider(f, 1001);
            }
        });
        jPanel.add(this.secondSynthButtonOn);
        jPanel.add(this.secondSynthButtonOff);
        jPanel.add(this.slider2);
        jPanel.add(this.textBox2);
        this.add(jPanel);
    }

    protected void addThirdSynthPanel() {
        JPanel jPanel = this.makeNewJPanel();
        jPanel.setBackground(new Color(13, 23, 0));
        this.thirdSynthButtonOn = new JButton("On");
        this.thirdSynthButtonOff = new JButton("Off");
        this.thirdSynthButtonOff.setEnabled(false);
        this.slider3 = new JSlider(0);
        this.slider3.setMinimum(0);
        this.slider3.setMaximum(10000);
        this.slider3.setEnabled(false);
        this.textBox3 = new JTextField(String.valueOf(0), 8);
        this.textBox3.setEnabled(false);
        this.thirdSynthButtonOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOn(440.0f, 1002);
                OscUI.this.thirdSynthButtonOn.setEnabled(false);
                OscUI.this.thirdSynthButtonOff.setEnabled(true);
                OscUI.this.slider3.setEnabled(true);
                OscUI.this.slider3.setValue(2050);
                OscUI.this.textBox3.setEnabled(true);
                OscUI.this.textBox3.setText("440.0");
            }
        });
        this.thirdSynthButtonOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OscUI.this.doSendOff(1002);
                OscUI.this.thirdSynthButtonOn.setEnabled(true);
                OscUI.this.thirdSynthButtonOff.setEnabled(false);
                OscUI.this.slider3.setEnabled(false);
                OscUI.this.slider3.setValue(0);
                OscUI.this.textBox3.setEnabled(false);
                OscUI.this.textBox3.setText("0");
            }
        });
        this.slider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    float f = jSlider.getValue();
                    f = f / 10000.0f * (f / 10000.0f);
                    f *= 10000.0f;
                    OscUI.this.doPrintValue3(f += 20.0f);
                    OscUI.this.doSendSlider(f, 1002);
                }
            }
        });
        this.textBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                float f = Float.valueOf(jTextField.getText()).floatValue();
                if (f > 10020.0f) {
                    f = 10020.0f;
                    OscUI.this.doPrintValue3(f);
                }
                if (f < 20.0f) {
                    f = 20.0f;
                    OscUI.this.doPrintValue3(f);
                }
                OscUI.this.slider3.setValue((int)(10000.0 * Math.sqrt((f - 20.0f) / 10000.0f)));
                OscUI.this.doSendSlider(f, 1002);
            }
        });
        jPanel.add(this.thirdSynthButtonOn);
        jPanel.add(this.thirdSynthButtonOff);
        jPanel.add(this.slider3);
        jPanel.add(this.textBox3);
        this.add(jPanel);
    }

    protected JPanel makeNewJPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        return jPanel;
    }

    protected JPanel makeNewJPanel1() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        return jPanel;
    }

    public void addressChanged() {
        try {
            this.oscPort = new OSCPortOut(InetAddress.getByName(this.addressWidget.getText()));
        }
        catch (Exception exception) {
            this.showError("Couldn't set address");
        }
    }

    public void doSendOn(float f, int n) {
        if (null == this.oscPort) {
            this.showError("Please set an address first");
        }
        Object[] objectArray = new Object[]{"javaosc-example", new Integer(n), new Integer(1), new Integer(0), "freq", new Float(f)};
        OSCMessage oSCMessage = new OSCMessage("/s_new", objectArray);
        try {
            this.oscPort.send(oSCMessage);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
    }

    public void doSendOff(int n) {
        if (null == this.oscPort) {
            this.showError("Please set an address first");
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        OSCMessage oSCMessage = new OSCMessage("/n_free", objectArray);
        try {
            this.oscPort.send(oSCMessage);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
    }

    public void doPrintValue(float f) {
        String string = new String();
        this.textBox.setText(String.valueOf(f));
    }

    public void doPrintValue2(float f) {
        String string = new String();
        this.textBox2.setText(String.valueOf(f));
    }

    public void doPrintValue3(float f) {
        String string = new String();
        this.textBox3.setText(String.valueOf(f));
    }

    public void doSendSlider(float f, int n) {
        if (null == this.oscPort) {
            this.showError("Please set an address first");
        }
        Object[] objectArray = new Object[]{new Integer(n), "freq", new Float(f)};
        OSCMessage oSCMessage = new OSCMessage("/n_set", objectArray);
        try {
            this.oscPort.send(oSCMessage);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
    }

    public void doSendGlobalOff(int n, int n2, int n3) {
        if (null == this.oscPort) {
            this.showError("Please set an address first");
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        OSCMessage oSCMessage = new OSCMessage("/n_free", objectArray);
        Object[] objectArray2 = new Object[]{new Integer(n2)};
        OSCMessage oSCMessage2 = new OSCMessage("/n_free", objectArray2);
        Object[] objectArray3 = new Object[]{new Integer(n3)};
        OSCMessage oSCMessage3 = new OSCMessage("/n_free", objectArray3);
        OSCPacket[] oSCPacketArray = new OSCPacket[]{oSCMessage, oSCMessage2, oSCMessage3};
        Date date = new Date();
        long l = date.getTime();
        Integer n4 = Integer.valueOf(this.textBox4.getText());
        date.setTime(l += n4.longValue());
        OSCBundle oSCBundle = new OSCBundle(oSCPacketArray, date);
        try {
            this.oscPort.send(oSCBundle);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
    }

    public void doSendGlobalOn(int n, int n2, int n3) {
        if (null == this.oscPort) {
            this.showError("Please set an address first");
        }
        Object[] objectArray = new Object[]{"javaosc-example", new Integer(n), new Integer(1), new Integer(0)};
        OSCMessage oSCMessage = new OSCMessage("/s_new", objectArray);
        Object[] objectArray2 = new Object[]{"javaosc-example", new Integer(n2), new Integer(1), new Integer(0)};
        OSCMessage oSCMessage2 = new OSCMessage("/s_new", objectArray2);
        Object[] objectArray3 = new Object[]{"javaosc-example", new Integer(n3), new Integer(1), new Integer(0)};
        OSCMessage oSCMessage3 = new OSCMessage("/s_new", objectArray3);
        try {
            this.oscPort.send(oSCMessage);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
        try {
            this.oscPort.send(oSCMessage2);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
        try {
            this.oscPort.send(oSCMessage3);
        }
        catch (Exception exception) {
            this.showError("Couldn't send");
        }
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(this.parent, string);
    }
}

