/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.test;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.OSCPortIn;
import com.illposed.osc.OSCPortOut;
import java.util.Date;
import junit.framework.TestCase;

public class OSCPortTest
extends TestCase {
    boolean messageReceived;
    Date receivedTimestamp;
    OSCPortOut sender;
    OSCPortIn receiver;

    public OSCPortTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sender = new OSCPortOut();
        this.receiver = new OSCPortIn(OSCPort.defaultSCOSCPort());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.sender.close();
        this.receiver.close();
    }

    public void testStart() throws Exception {
        OSCMessage oSCMessage = new OSCMessage("/sc/stop");
        this.sender.send(oSCMessage);
    }

    public void testMessageWithArgs() throws Exception {
        Object[] objectArray = new Object[]{new Integer(3), "hello"};
        OSCMessage oSCMessage = new OSCMessage("/foo/bar", objectArray);
        this.sender.send(oSCMessage);
    }

    public void testBundle() throws Exception {
        Object[] objectArray = new Object[2];
        OSCPacket[] oSCPacketArray = new OSCPacket[1];
        objectArray[0] = new Integer(3);
        objectArray[1] = "hello";
        OSCMessage oSCMessage = new OSCMessage("/foo/bar", objectArray);
        oSCPacketArray[0] = oSCMessage;
        OSCBundle oSCBundle = new OSCBundle(oSCPacketArray);
        this.sender.send(oSCBundle);
    }

    public void testBundle2() throws Exception {
        OSCMessage oSCMessage = new OSCMessage("/foo/bar");
        oSCMessage.addArgument(new Integer(3));
        oSCMessage.addArgument("hello");
        OSCBundle oSCBundle = new OSCBundle();
        oSCBundle.addPacket(oSCMessage);
        this.sender.send(oSCBundle);
    }

    public void testReceiving() throws Exception {
        OSCMessage oSCMessage = new OSCMessage("/message/receiving");
        this.messageReceived = false;
        OSCListener oSCListener = new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oSCMessage) {
                OSCPortTest.this.messageReceived = true;
            }
        };
        this.receiver.addListener("/message/receiving", oSCListener);
        this.receiver.startListening();
        this.sender.send(oSCMessage);
        Thread.sleep(100L);
        this.receiver.stopListening();
        if (!this.messageReceived) {
            OSCPortTest.fail((String)"Message was not received");
        }
    }

    public void testBundleReceiving() throws Exception {
        OSCBundle oSCBundle = new OSCBundle();
        oSCBundle.addPacket(new OSCMessage("/bundle/receiving"));
        this.messageReceived = false;
        this.receivedTimestamp = null;
        OSCListener oSCListener = new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oSCMessage) {
                OSCPortTest.this.messageReceived = true;
                OSCPortTest.this.receivedTimestamp = date;
            }
        };
        this.receiver.addListener("/bundle/receiving", oSCListener);
        this.receiver.startListening();
        this.sender.send(oSCBundle);
        Thread.sleep(100L);
        this.receiver.stopListening();
        if (!this.messageReceived) {
            OSCPortTest.fail((String)"Message was not received");
        }
        if (!this.receivedTimestamp.equals(oSCBundle.getTimestamp())) {
            OSCPortTest.fail((String)("Message should have timestamp " + oSCBundle.getTimestamp() + " but has " + this.receivedTimestamp));
        }
    }
}

