/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.test;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.util.Date;
import junit.framework.TestCase;

public class OSCPacketDispatcherTest
extends TestCase {
    OSCPacketDispatcher dispatcher;
    boolean receivedOnListener1;
    boolean receivedOnListener2;

    protected void setUp() throws Exception {
        this.dispatcher = new OSCPacketDispatcher();
        OSCListener oSCListener = new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oSCMessage) {
                OSCPacketDispatcherTest.this.receivedOnListener1 = true;
            }
        };
        this.dispatcher.addListener("/listener1", oSCListener);
        oSCListener = new OSCListener(){

            public void acceptMessage(Date date, OSCMessage oSCMessage) {
                OSCPacketDispatcherTest.this.receivedOnListener2 = true;
            }
        };
        this.dispatcher.addListener("/listener2", oSCListener);
    }

    protected void tearDown() throws Exception {
    }

    public void testDispatchToListener1() throws Exception {
        this.receivedOnListener1 = false;
        this.receivedOnListener2 = false;
        OSCMessage oSCMessage = new OSCMessage("/listener1");
        this.dispatcher.dispatchPacket(oSCMessage);
        if (!this.receivedOnListener1) {
            OSCPacketDispatcherTest.fail((String)"Message to listener1 didn't get sent to listener1");
        }
        if (this.receivedOnListener2) {
            OSCPacketDispatcherTest.fail((String)"Message to listener1 got sent to listener2");
        }
    }

    public void testDispatchToListener2() throws Exception {
        this.receivedOnListener1 = false;
        this.receivedOnListener2 = false;
        OSCMessage oSCMessage = new OSCMessage("/listener2");
        this.dispatcher.dispatchPacket(oSCMessage);
        if (this.receivedOnListener1) {
            OSCPacketDispatcherTest.fail((String)"Message to listener2 got sent to listener1");
        }
        if (!this.receivedOnListener2) {
            OSCPacketDispatcherTest.fail((String)"Message to listener2 didn't get sent to listener2");
        }
    }

    public void testDispatchToNobody() throws Exception {
        this.receivedOnListener1 = false;
        this.receivedOnListener2 = false;
        OSCMessage oSCMessage = new OSCMessage("/nobody");
        this.dispatcher.dispatchPacket(oSCMessage);
        if (this.receivedOnListener1 || this.receivedOnListener2) {
            OSCPacketDispatcherTest.fail((String)"Message to nobody got dispatched incorrectly");
        }
    }

    public void testDispatchBundle() throws Exception {
        this.receivedOnListener1 = false;
        this.receivedOnListener2 = false;
        OSCBundle oSCBundle = new OSCBundle();
        oSCBundle.addPacket(new OSCMessage("/listener1"));
        oSCBundle.addPacket(new OSCMessage("/listener2"));
        this.dispatcher.dispatchPacket(oSCBundle);
        if (!this.receivedOnListener1) {
            OSCPacketDispatcherTest.fail((String)"Bundle didn't dispatch message to listener 1");
        }
        if (!this.receivedOnListener2) {
            OSCPacketDispatcherTest.fail((String)"Bundle didn't dispatch message to listener 2");
        }
    }
}

