/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.test;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import java.util.Date;
import junit.framework.TestCase;

public class OSCByteArrayToJavaConverterTest
extends TestCase {
    OSCByteArrayToJavaConverter converter;

    protected void setUp() throws Exception {
        this.converter = new OSCByteArrayToJavaConverter();
    }

    protected void tearDown() throws Exception {
    }

    public void testReadSimplePacket() throws Exception {
        byte[] byArray = new byte[]{47, 115, 99, 47, 114, 117, 110, 0, 44, 0, 0, 0};
        OSCMessage oSCMessage = (OSCMessage)this.converter.convert(byArray, byArray.length);
        if (!oSCMessage.getAddress().equals("/sc/run")) {
            OSCByteArrayToJavaConverterTest.fail((String)("Address should be /sc/run, but is " + oSCMessage.getAddress()));
        }
    }

    public void testReadComplexPacket() throws Exception {
        Object[] objectArray;
        byte[] byArray = new byte[]{47, 115, 95, 110, 101, 119, 0, 0, 44, 105, 115, 102, 0, 0, 0, 0, 0, 0, 3, -23, 102, 114, 101, 113, 0, 0, 0, 0, 67, -36, 0, 0};
        OSCMessage oSCMessage = (OSCMessage)this.converter.convert(byArray, byArray.length);
        if (!oSCMessage.getAddress().equals("/s_new")) {
            OSCByteArrayToJavaConverterTest.fail((String)("Address should be /s_new, but is " + oSCMessage.getAddress()));
        }
        if ((objectArray = oSCMessage.getArguments()).length != 3) {
            OSCByteArrayToJavaConverterTest.fail((String)("Num arguments should be 3, but is " + objectArray.length));
        }
        if (!new Integer(1001).equals(objectArray[0])) {
            OSCByteArrayToJavaConverterTest.fail((String)("Argument 1 should be 1001, but is " + objectArray[0]));
        }
        if (!"freq".equals(objectArray[1])) {
            OSCByteArrayToJavaConverterTest.fail((String)("Argument 2 should be freq, but is " + objectArray[1]));
        }
        if (!new Float(440.0).equals(objectArray[2])) {
            OSCByteArrayToJavaConverterTest.fail((String)("Argument 3 should be 440.0, but is " + objectArray[2]));
        }
    }

    public void testReadBundle() throws Exception {
        OSCMessage oSCMessage;
        OSCPacket[] oSCPacketArray;
        byte[] byArray = new byte[]{35, 98, 117, 110, 100, 108, 101, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 47, 116, 101, 115, 116, 0, 0, 0, 44, 0, 0, 0};
        OSCBundle oSCBundle = (OSCBundle)this.converter.convert(byArray, byArray.length);
        if (!oSCBundle.getTimestamp().equals(new Date(0L))) {
            OSCByteArrayToJavaConverterTest.fail((String)("Timestamp should be 0, but is " + oSCBundle.getTimestamp()));
        }
        if ((oSCPacketArray = oSCBundle.getPackets()).length != 1) {
            OSCByteArrayToJavaConverterTest.fail((String)("Num packets should be 1, but is " + oSCPacketArray.length));
        }
        if (!"/test".equals((oSCMessage = (OSCMessage)oSCPacketArray[0]).getAddress())) {
            OSCByteArrayToJavaConverterTest.fail((String)("Address of message should be /test, but is " + oSCMessage.getAddress()));
        }
    }
}

