/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.test;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class OSCBundleTest
extends TestCase {
    public OSCBundleTest(String string) {
        super(string);
    }

    public void testSendBundle() {
        OSCPacket[] oSCPacketArray;
        OSCMessage oSCMessage;
        Date date = GregorianCalendar.getInstance().getTime();
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        OSCBundle oSCBundle = new OSCBundle(new OSCPacket[]{new OSCMessage("/dummy")}, date);
        byte[] byArray = oSCBundle.getByteArray();
        OSCBundle oSCBundle2 = (OSCBundle)oSCByteArrayToJavaConverter.convert(byArray, byArray.length);
        if (!oSCBundle2.getTimestamp().equals(date)) {
            OSCBundleTest.fail((String)("Send Bundle did not receive the correct timestamp " + oSCBundle2.getTimestamp() + "(" + oSCBundle2.getTimestamp().getTime() + ") (should be " + date + "( " + date.getTime() + ")) "));
        }
        if (!(oSCMessage = (OSCMessage)(oSCPacketArray = oSCBundle2.getPackets())[0]).getAddress().equals("/dummy")) {
            OSCBundleTest.fail((String)"Send Bundle's message did not receive the correct address");
        }
    }

    public void testSendBundleImmediate() {
        OSCPacket[] oSCPacketArray;
        OSCMessage oSCMessage;
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        OSCBundle oSCBundle = new OSCBundle(new OSCPacket[]{new OSCMessage("/dummy")});
        byte[] byArray = oSCBundle.getByteArray();
        OSCBundle oSCBundle2 = (OSCBundle)oSCByteArrayToJavaConverter.convert(byArray, byArray.length);
        if (!oSCBundle2.getTimestamp().equals(OSCBundle.TIMESTAMP_IMMEDIATE)) {
            OSCBundleTest.fail((String)("Timestamp should have been immediate, not " + oSCBundle2.getTimestamp() + "(" + oSCBundle2.getTimestamp().getTime() + ")"));
        }
        if (!(oSCMessage = (OSCMessage)(oSCPacketArray = oSCBundle2.getPackets())[0]).getAddress().equals("/dummy")) {
            OSCBundleTest.fail((String)"Send Bundle's message did not receive the correct address");
        }
    }
}

