/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class OSCPortOut
extends OSCPort {
    protected InetAddress address;

    public OSCPortOut(InetAddress inetAddress, int n) throws SocketException {
        this.socket = new DatagramSocket();
        this.address = inetAddress;
        this.port = n;
    }

    public OSCPortOut(InetAddress inetAddress) throws SocketException {
        this(inetAddress, OSCPortOut.defaultSCOSCPort());
    }

    public OSCPortOut() throws UnknownHostException, SocketException {
        this(InetAddress.getLocalHost(), OSCPortOut.defaultSCOSCPort());
    }

    public void send(OSCPacket oSCPacket) throws IOException {
        byte[] byArray = oSCPacket.getByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.address, this.port);
        this.socket.send(datagramPacket);
    }
}

