class collector(object):
    lastMagDegree=0
    magDegree=0
    yaw=0  
    roll=0
    pitch=0
    battery=0  
    flightTime=0
    accx=1
    accy=1
    accz=1
    pos=[0,0]
    def __init__(self,state=0,ip=0,port=0):
        self.moniClass="collector"
#        self.collectorVlue=["magDegree","yaw","pitch","roll","battery"]#,"x","y","z"]
        self.collectorVlue=["magDegree","yaw","pitch","roll","battery","flightTime"]
#        self.collectorType=["float","float","float","float","float"]#,"float","float"]#,"float"]
        self.collectorType=["float","float","float","float","float","int32_t"]
        if(state==1):
            self.makeReceiver(ip,port )

        
    def getDirect(self):
        return self.yaw
    def getPositionByMag(self):
        return self.magDegree
    def getPositionByCam(self):
        return self.pos[:]
    def getBattery(self):
        return self.battery

    def isMoving(self):
        err=self.lastMagDegree-self.magDegree
        self.lastMagDegree=self.magDegree
        if(err>15 or err<-15):
            return 1
        else:
            return 0    
    def setCollectorContents(self,collectorContents):
        self.magDegree=collectorContents[0]
        self.yaw=collectorContents[1]
        self.pitch=collectorContents[2]
        self.roll=collectorContents[3]
        self.battery=collectorContents[4]
        self.flightTime=float(collectorContents[5])/100
#        self.accx=float(collectorContents[5])
#        self.accy=float(collectorContents[6])
#        self.accz=float(collectorContents[7])
    def setAcc(self,x,y,z):
        self.accx=x
        self.accy=y
        self.accz=z


    def getPitch(self):
        return self.pitch
    def getRoll(self):
        return self.roll                    
    def getCollectorVlue(self):
        return self.collectorVlue
    def getCollectorType(self):
        return self.collectorType
    def getMoniClass(self):
        return self.moniClass
    def setPosition(self,pos):
        self.pos=pos
    def getFlightTime(self):
        return self.flightTime
    def getAccX(self):
        return self.accx
    def getAccY(self):
        return self.accy
    def getAccZ(self):
        return self.accz