import time
import math
class actor():
    roll=0.0
    pitch=0.0
    yaw=0.0
    thrust =0
    offsetPitch=0
    offsetRoll=0
    groundBaseThrust=0
    jumpThrust=0
    flyingThrust=51500
              
    def __init__(self,gThrust,jThrust):
        self.groundBaseThrust=gThrust
        self.jumpThrust=jThrust
    def groundMove2(self,direct,yaw,deg):
        self.setDirect2(direct,yaw, deg);
        self.thrust=self.groundBaseThrust
    def groundMoveBreakeDirect(self,direct,yaw,deg):
        self.calcBrakeDirect(direct, yaw, deg)
        self.thrust=self.groundBaseThrust
    def groundMoveToDirect(self,direct,yaw,deg):
        self.calcDirect(direct, yaw, deg)        
        self.thrust=self.groundBaseThrust
    def groundMove(self,direct,speed):
        self.setDirect(direct,speed)
        self.thrust=self.groundBaseThrust
    def groundMoveAtStair(self,direct,speed):
        self.setDirect(direct,speed)
        self.thrust=self.groundBaseThrust
    def groundStop(self):
        self.pitch=self.roll=self.yaw=0.0
        self.thrust=0
    def hover(self):
        self.pitch=self.roll=self.yaw=0.0 
        self.thrust=self.groundBaseThrust
    def weakenHover(self,weak):
        self.pitch=self.roll=self.yaw=0.0 
        self.thrust=self.groundBaseThrust-weak
  
    def hop(self,direct,jumptime=0.4):
        self.setDirect(direct,40)
        self.thrust=self.jumpThrust
        time.sleep(jumptime)
        self.groundStop()

    def hop2(self,direct,yaw,jumptime=0.4):
        self.setDirect2(direct,yaw,40)
        self.thrust=self.jumpThrust
        time.sleep(jumptime)
        counta=0
        while(counta<10):
            self.thrust=self.jumpThrust-3000*counta
            counta=counta+1
            time.sleep(0.02)
        self.groundStop()

    
    def downStairs(self,direct,yaw):
        self.setDirect2(direct,yaw,20)
        self.thrust=self.flyingThrust
        time.sleep(0.5)
        if direct=="RIGHT":
            self.setDirect2("LEFT",yaw, 15)
        elif direct=="FORWARD":
            self.setDirect2("BACK",yaw,15)
        elif direct=="LEFT":
            self.setDirect2("RIGHT",yaw,15)
        elif direct=="BACK":
            self.setDirect2("FORWARD",yaw, 15)
        self.thrust=self.groundBaseThrust-5000
        time.sleep(1)
        self.groundStop()
    
    def adjustDirect(self,x,y):
        self.offsetRoll=x
        self.offsetPitch=y
        
    def setDirect(self,direct,deg):
        if direct=="RIGHT" :
            self.setPitchRoll(0, deg)
        elif direct=="FORWARD":
            self.setPitchRoll(deg, 0)
        elif direct=="LEFT":
            self.setPitchRoll(0, -deg)
        elif direct=="BACK":
            self.setPitchRoll(-deg, 0)  
        elif direct=="RF":
            self.setPitchRoll(-deg,deg)
        elif direct=="RB":
            self.setPitchRoll(-deg, -deg)
        elif direct=="LF":
            self.setPitchRoll(-deg, deg)
        elif direct=="LB":
            self.setPitchRoll(-deg,-deg)
    
    def calcBrakeDirect(self,direct,yaw,deg):
        if(direct<0):
            direct=direct+180
        if(direct>0):
            direct=direct-180
        self.calcDirect(direct,yaw,deg)
    
     
    def setDirect2(self,direct,yaw,deg):
        if(direct=="FORWARD"):
            self.calcDirect(0, yaw, deg)
        elif(direct=="RF"):
            self.calcDirect(-45, yaw, deg)
        elif(direct=="RIGHT"):
            self.calcDirect(-90,yaw,deg)
        elif(direct=="RB"):
            self.calcDirect(-135, yaw, deg)
        elif(direct=="BACK"):
            self.calcDirect(180,yaw,deg)
        elif(direct=="LB"):
            self.calcDirect(135, yaw, deg)
        elif(direct=="LEFT"):
            self.calcDirect(90,yaw,deg)
            yaw=yaw+90
        elif(direct=="LF"):
            self.calcDirect(45,yaw,deg)
            


    def calcDirect(self,direct, yaw,deg):
        target=yaw+direct
        if(target<-180):
            target=target+360
        elif(target>180):
            target=target-360
        rad=target*math.pi/180
        moth=math.sqrt((1+math.pow(math.tan(rad), 2)))
        a=deg/moth
        b=a*math.fabs(math.tan(rad))
        if(target<=90 and target>0):
            self.setPitchRoll(a, -b)
            print(str(target)+"(yaw"+str(yaw)+",direct"+str(direct)+"): "+str(a)+" "+str(-b))
        elif(target>90 and target<=180):
            self.setPitchRoll(-a, -b)
            print(str(target)+"(yaw"+str(yaw)+",direct"+str(direct)+"): "+str(-a)+" "+str(-b))
        elif(target>-180 and target<=-90):
            self.setPitchRoll(-a, b)
            print(str(target)+"(yaw"+str(yaw)+",direct"+str(direct)+"): "+str(-a)+" "+str(b))
        elif(target<=0 and target>-90):
            self.setPitchRoll(a, b)
            print(str(target)+"(yaw"+str(yaw)+",direct"+str(direct)+"): "+str(a)+" "+str(b))
        
                
    def modifyDirect(self,direct):
        self.thrust=self.jumpThrust
        if(direct>0):
            self.pitch=self.roll=0
            self.yaw=-120
        elif(direct<0):
            self.pitch=self.roll=0
            self.yaw=120
    def modifyDirect2(self,direct):
        self.thrust=self.groundBaseThrust
        if(direct>0):
            self.yaw=80
        elif(direct<0):
            self.yaw=-80            
    def setPitchRoll(self,p,r):
        self.pitch=self.offsetPitch+p
        self.roll=self.offsetRoll+r
    def setGroundJumpFlying(self,g,j,f):
        self.groundBaseThrust=g
        self.jumpThrust=j
        self.flyingThrust=f