import PyQt4.QtGui as QtGui
from PyQt4 import QtCore
import sys
import time
import cfgui
from hsLogger import hsLogger
from threading import Thread
from sweepingRobot_2014 import hoppingSweeper
from extractConfigure import extractConfigure

#logging.basicConfig(level=logging.DEBUG)

class hsMain(QtGui.QWidget):
    mode=0                                                                                                                          
    def __init__(self):
        super(hsMain,self).__init__()
        #self.hs=hoppingSweeper.hoppingSweeper("radio://0/6/250K",43000,47000)
        self.hs=hoppingSweeper.hoppingSweeper("radio://0/10/250K",45000,48000)
        self.panel =cfgui.panel_widget()
        self.ec=extractConfigure()
        self.mainWindow=cfgui.Main_Window()
        self.panel=self.mainWindow.panel
        self.setInterface()
        self.hslogger=hsLogger()
        self.hslogger.makelogger()
        self.getConfigure()
        
    def setInterface(self):
        self.panel.button_widget.connect_button.clicked.connect(self.getConnection)
        self.panel.button_widget.connect_button.clicked.connect(self.panel.button_widget.connect_disenable)
        self.panel.button_widget.disconnect_button.clicked.connect(self.disConnection)
        self.panel.button_widget.disconnect_button.clicked.connect(self.panel.button_widget.connect_enable)

        self.panel.log_widget.val1.setText("X Position")
        self.panel.log_widget.val2.setText("Y Position")
        self.panel.log_widget.val3.setText("Direction")
        self.panel.log_widget.val4.setText("accX")
        self.panel.log_widget.val5.setText("accY")
        self.panel.log_widget.val6.setText("accZ")
        self.panel.log_widget.val7.setText("pitch")
        self.panel.log_widget.val8.setText("roll")

        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.panel.thrust_widget.change_thrustValue)
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.panel.thrust_widget.change_rollValue)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.panel.thrust_widget.change_pitchValue)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.panel.thrust_widget.change_yawValue)
        
        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.change_thrust)    
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.change_roll)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.change_pitch)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.change_yaw)
    
        self.panel.Checkbox_widget.mode1_box.stateChanged.connect(self.setmode1)
        self.panel.Checkbox_widget.mode2_box.stateChanged.connect(self.setmode2)
        self.panel.Checkbox_widget.manual_box.stateChanged.connect(self.setmanual)
        
        self.panel.direction_widget.stopButton.pressed.connect(self.stop_motion)
        #self.panel.direction_widget.stopButton.released.connect(self.default_motion)
        self.panel.direction_widget.hoverButton.pressed.connect(self.hover_motion)
        #self.panel.direction_widget.hoverButton.released.connect(self.default_motion)
        self.panel.direction_widget.hopButton.pressed.connect(self.hop_motion)
        #self.panel.direction_widget.hopButton.released.connect(self.default_motion)
        self.panel.direction_widget.adaptiveButton.pressed.connect(self.adaptive_motion)
        #self.panel.direction_widget.adaptiveButton.released.connect(self.default_motion)
        self.panel.direction_widget.stairsButton.pressed.connect(self.stairSweep_motion)

        self.panel.th_widget.safety_th_vale.setText(str(self.hs.analyzer.goal_th))
        self.panel.th_widget.position_th_vale.setText(str(self.hs.analyzer.safety_th))
        self.panel.th_widget.setButton.pressed.connect(self.setTh)
        
        self.panel.thrust_set_widget.groundThrust_value.setText(str(self.hs.actor.groundBaseThrust))
        self.panel.thrust_set_widget.jumpThrust_value.setText(str(self.hs.actor.jumpThrust))
        self.panel.thrust_set_widget.Flyingthrust_value.setText(str(self.hs.actor.flyingThrust))
        self.panel.thrust_set_widget.setButton.pressed.connect(self.setThrusts)

        self.panel.Speed_set_widget.speed_value.setText(str(self.hs.decider.hoverSpeed))
        self.panel.Speed_set_widget.span_value.setText(str(self.hs.decider.limit))
        self.panel.Speed_set_widget.setButton.pressed.connect(self.setSpeed)

        self.panel.tablesize_wdiget.setButton.pressed.connect(self.setTableSize)
        self.panel.tablesize_wdiget.TableE_value.setText(str(self.hs.analyzer.criteria.tableE))
        self.panel.tablesize_wdiget.TableS_value.setText(str(self.hs.analyzer.criteria.tableS))
        self.panel.tablesize_wdiget.TableR_value.setText(str(self.hs.analyzer.criteria.tableR))
        self.panel.tablesize_wdiget.TableL_value.setText(str(self.hs.analyzer.criteria.tableL))
        
        self.mainWindow.file_menu.addAction('Open Map...',self.getMapFile)
        self.mainWindow.file_menu.addAction('Save Map...',self.saveMapFile)
        self.mainWindow.file_menu.addAction('Open Configure...',self.getConfigure)
        self.mainWindow.file_menu.addAction('Save Configure...',self.saveConfigure)
    def getMapFile(self):
        goalList=self.ec.getMapFromFile(QtGui.QFileDialog.getOpenFileName(self.mainWindow, 'Open file','.'))
        self.hs.analyzer.path.setGoal(goalList)
        self.panel.mapWidget.map.setText(self.ec.getFiledata())
    def saveMapFile(self):
        print(self.panel.mapWidget.map.toPlainText())
        self.ec.saveFiledata(QtGui.QFileDialog.getSaveFileName(self.mainWindow,'Save file', '.'),self.panel.mapWidget.map.toPlainText())
    def getConfigure(self):
        confList=self.ec.getConfigureFromFile(QtGui.QFileDialog.getOpenFileName(self.mainWindow, 'Open file','.'))
        self.panel.thrust_set_widget.groundThrust_value.setText(str(confList[0]))
        self.panel.thrust_set_widget.jumpThrust_value.setText(str(confList[1]))
        self.panel.tablesize_wdiget.TableE_value.setText(str(confList[2]))
        self.panel.tablesize_wdiget.TableL_value.setText(str(confList[3]))
        self.panel.tablesize_wdiget.TableR_value.setText(str(confList[4]))
        self.panel.tablesize_wdiget.TableS_value.setText(str(confList[5]))
        self.panel.th_widget.safety_th_vale.setText(str(confList[6]))
        self.panel.th_widget.position_th_vale.setText(str(confList[7]))
        self.panel.Speed_set_widget.speed_value.setText(str(confList[8]))
        self.panel.Speed_set_widget.span_value.setText(str(confList[9]))

        print(confList)
        self.setThrusts()
        self.setTh()
        self.setTableSize()
        self.setSpeed()
    
    def saveConfigure(self):
        lis =[
              self.panel.thrust_set_widget.groundThrust_value.text(),
              self.panel.thrust_set_widget.jumpThrust_value.text(),
              self.panel.tablesize_wdiget.TableE_value.text(),
              self.panel.tablesize_wdiget.TableL_value.text(),
              self.panel.tablesize_wdiget.TableR_value.text(),
              self.panel.tablesize_wdiget.TableS_value.text(),
              self.panel.th_widget.safety_th_vale.text(),
              self.panel.th_widget.position_th_vale.text(),
              self.panel.Speed_set_widget.speed_value.text(),
              self.panel.Speed_set_widget.span_value.text()
        ]        
        self.ec.saveConfigure(lis, QtGui.QFileDialog.getSaveFileName(self.mainWindow, 'Save file','.'))


    def setTh(self):
        pth=float(self.panel.th_widget.position_th_vale.text())
        sth=float(self.panel.th_widget.safety_th_vale.text())
        self.hs.analyzer.setGoal_th(pth)
        self.hs.analyzer.setSafety_th(sth)
        print("set th(safety,goal)")

    def setThrusts(self):
        ground=float(self.panel.thrust_set_widget.groundThrust_value.text())
        jump=float(self.panel.thrust_set_widget.jumpThrust_value.text())
        flying=float(self.panel.thrust_set_widget.Flyingthrust_value.text())
        self.hs.actor.setGroundJumpFlying(ground, jump,flying)

    def setTableSize(self):
        tE=float(self.panel.tablesize_wdiget.TableE_value.text())
        tS=float(self.panel.tablesize_wdiget.TableS_value.text())
        tR=float(self.panel.tablesize_wdiget.TableR_value.text())
        tL=float(self.panel.tablesize_wdiget.TableL_value.text())

        self.hs.analyzer.criteria.setTableSize(tS, tE, tR, tL)
        print("set TableSize")
        
    def setSpeed(self):
        speed=int(self.panel.Speed_set_widget.speed_value.text())
        span=int(self.panel.Speed_set_widget.span_value.text())
        self.hs.decider.setHoverSpeedAndLimit(speed,span)
        print("setSpeed")

    def change_thrust(self,value):
        if value==0:
            self.hs.actor.thrust =value
        else:
            self.hs.actor.thrust =value*499+10001  
    def change_pitch(self,value):
        self.hs.actor.pitch=value
    def change_roll(self,value):
        self.hs.actor.roll=value
    def change_yaw(self,value):
        self.hs.actor.yaw=value
    def setmode1(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "1")
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "0")            
    def setmode2(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("flightmode.althold","1")
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode1_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.hs.crazyflie.param.set_value("flightmode.althold", "0") 
    def setmanual(self,state):
        if(state!=0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "3")
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.mode1_box.checkState()==0):
            self.hs.crazyflie.param.set_value("mode.modeValue", "0")      
    def stop_motion(self):
        i=0
        while i<150:
            if( i<75):
                print("F")
                self.hs.actor.groundMoveToDirect(180,self.hs.collector.getDirect(), 45)
            else:
                print("hover")
                self.hs.actor.hover()
                
            i=i+1
            time.sleep(0.01)
#        self.hs.actor.groundMove("FORWARD",15)
        self.hs.stopMotionLoop()

    def hover_motion(self):
        time.sleep(1)
        Thread(target=self.hs.startHoverOperation).start()
        
    def hop_motion(self):
        time.sleep(1)
        Thread(target=self.hs.startOperation2).start()
    def adaptive_motion(self):
        print(self.hs.analyzer.analyzeRemainPath())
        time.sleep(1)
        #self.hs.startOperationT()
        Thread(target=self.hs.startAdaptationLogic).start()
    def stairSweep_motion(self):
        time.sleep(0.5)
        Thread(target=self.hs.startStairSweepOperation).start()
    def default_motion(self):
        self.pitch=0
        self.roll=0

    def getConnection(self):
        self.hs.getConnection()
        #self.hs0.getConnection()
        self.f=open('data.txt','w')
        Thread(target=self.logUpdater).start()
    def disConnection(self):
        self.p=0
        self.hs.stopOperation()

        self.hs.disConnection()
        #self.f.close()

    def logUpdater(self):
        self.p=1
        self.hslogger.log_messsage(
                                    #"state"+","
                                    #+"seaquens+","
                                    "resultX"+","
                                    +"resultY"+","
                                    +"resultOfYaw"+","
                                    +"remain"+","
                                    +"state"+","
                                    +"xSafety"+","
                                    +"ySafety"+","
                                    +"x"+","
                                    +"y"+","
                                    #"goal"+","
                                    +"timeCounter"+","
                                    +"flightTime"+","
                                    +"cpi"+","
                                    +"spi"+","
                                    +"ev"+","
                                    +"ac"+","
                                    +"pv"+","
                                    #+"strategy"
                                   )

        while self.p==1:
            self.panel.log_widget.val1Value.setText("%.2f"%self.hs.collector.getPositionByCam()[0])
            self.panel.log_widget.val2Value.setText("%.2f"%self.hs.collector.getPositionByCam()[1])
            self.panel.log_widget.val3Value.setText("%.2f"%self.hs.collector.getDirect())
            self.panel.log_widget.val4Value.setText("%.2f"%self.hs.collector.getAccX())
            self.panel.log_widget.val5Value.setText("%.2f"%self.hs.collector.getAccY())
            self.panel.log_widget.val6Value.setText("%.2f"%self.hs.collector.getAccZ())
            self.panel.log_widget.val7Value.setText("%.2f"%self.hs.collector.getPitch())
            self.panel.log_widget.val8Value.setText("%.2f"%self.hs.collector.getRoll())
            self.hslogger.log_messsage(
                                       #str(self.hs.decider.state)+","
                                       #+str(self.hs.decider.seaquense)+","
                                       str(self.hs.decider.result.resultOfPosition[0])+","
                                       +str(self.hs.decider.result.resultOfPosition[1])+","
                                       +str(self.hs.decider.result.resultOfYaw)+","
                                       +str(self.hs.remain)+","
                                       +str(self.hs.decider.state)+","
                                       +str(self.hs.decider.result.resultOfsafety[0])+","
                                       +str(self.hs.decider.result.resultOfsafety[1])+","
                                       +str(self.hs.collector.getPositionByCam()[0])+","
                                       +str(self.hs.collector.getPositionByCam()[1])+","
                                       
                                       #+str(self.hs.analyzer.goal)+","
                                       +str(self.hs.timeCounter)+","
                                       +str(self.hs.collector.flightTime)+","
                                       +str(self.hs.cpi)+","
                                       +str(self.hs.spi)+","
                                       +str(self.hs.ev)+","
                                       +str(self.hs.ac)+","
                                       +str(self.hs.pv)+","
                                       #+str(self.hs.strategy)
                                       )
            time.sleep(0.2)
            #self.panel.thrust_widget.thrust_slider.setValue(self.hs.actor.thrust)
            #self.panel.thrust_widget.roll_slider.setValue(self.hs.actor.roll)
            #self.panel.thrust_widget.pitch_slider.setValue(self.hs.actor.pitch)
            #self.panel.thrust_widget.yaw_slider.setValue(self.hs.actor.yaw)
 
def main():
    app =QtGui.QApplication(sys.argv)
    cf = hsMain()    
    cf.mainWindow.show()
    app.exec_()
    
if __name__=="__main__":
    main()