import logging
import PyQt4.QtGui as QtGui
import sys
import time
from threading import Thread

import cflib.crtp
from cfclient.utils.logconfigreader import LogConfig
from cfclient.utils.logconfigreader import LogVariable
from cflib.crazyflie import Crazyflie
import cfgui
from sweepingRobot_2014 import executor
from sweepingRobot_2014 import monitor
#logging.basicConfig(level=logging.DEBUG)

class cfMain():
    roll=0.0
    pitch=0.0
    yawrate=0
    thrust =0
    mode=0
    exe =executor.executor(39000,59000)
    def __init__(self):
        self.crazyflieA =Crazyflie()
        self.crazyflieA.connected.add_callback(self._connected)
        self.crazyflieA.disconnected.add_callback(self._disconnected)
        self.crazyflieA.connection_failed.add_callback(self._connection_failed)
        self.crazyflieA.connection_lost.add_callback(self._connection_lost)
        
        self.crazyflieB =Crazyflie()
        self.crazyflieB.connected.add_callback(self._connected)
        self.crazyflieB.disconnected.add_callback(self._disconnected)
        self.crazyflieB.connection_failed.add_callback(self._connection_failed)
        self.crazyflieB.connection_lost.add_callback(self._connection_lost)

        
        cflib.crtp.init_drivers()
        self.panel =cfgui.panel_widget()
        self.logname="acc"#"original" 
        self.val1="x"  
        self.valType1="float"
        self.val2="y"
        self.valType2="float"
        self.val3="z"
        self.valType3="float"
        self.val4="gx"
        self.valType4="float"
        self.val5="gy"
        self.valType5="float"
        self.setInterface()

    def setInterface(self):
        self.panel.button_widget.connect_button.clicked.connect(self.getConnection)
        self.panel.button_widget.connect_button.clicked.connect(self.panel.button_widget.connect_disenable)
        self.panel.button_widget.disconnect_button.clicked.connect(self.disConnection)
        self.panel.button_widget.disconnect_button.clicked.connect(self.panel.button_widget.connect_enable)

        self.panel.log_widget.val1.setText(self.val1)
        self.panel.log_widget.val2.setText(self.val2)
        self.panel.log_widget.val3.setText(self.val3)

        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.panel.thrust_widget.change_thrustValue)
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.panel.thrust_widget.change_rollValue)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.panel.thrust_widget.change_pitchValue)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.panel.thrust_widget.change_yawValue)

        self.panel.thrust_widget.thrust_slider.valueChanged.connect(self.change_thrust)    
        self.panel.thrust_widget.roll_slider.valueChanged.connect(self.change_roll)
        self.panel.thrust_widget.pitch_slider.valueChanged.connect(self.change_pitch)
        self.panel.thrust_widget.yaw_slider.valueChanged.connect(self.change_yaw)
    
        self.panel.Checkbox_widget.mode1_box.stateChanged.connect(self.setmode1)
        self.panel.Checkbox_widget.mode2_box.stateChanged.connect(self.setmode2)
        self.panel.Checkbox_widget.manual_box.stateChanged.connect(self.setmanual)
        self.panel.direction_widget.stopButton.pressed.connect(self.stop_motion)
        self.panel.direction_widget.stopButton.released.connect(self.default_motion)
        self.panel.direction_widget.hoverButton.pressed.connect(self.hover_motion)
        self.panel.direction_widget.hoverButton.released.connect(self.default_motion)
        self.panel.direction_widget.hopButton.pressed.connect(self.hop_motion)
        self.panel.direction_widget.hopButton.released.connect(self.default_motion)
        self.panel.direction_widget.adaptiveButton.pressed.connect(self.adaptive_motion)
        self.panel.direction_widget.adaptiveButton.released.connect(self.default_motion)

    def getConnection(self):
        self.crazyflieA.connected.add_callback(self._connected)
        
        self.crazyflieA.open_link("radio://0/10/250K")
        self.crazyflieB.open_link("radio://1/9/1M")
        self.th0= Thread(target=self.pulse_command)
        self.openFile();
    def openFile(self):
        self.f=open('data.txt','w')
        self.f.write(self.val4+","+self.val5+","+self.val1+","+self.val2+","+self.val3+"\n") 
    def setmode1(self,state):
        if(state!=0):
            self.crazyflieA.param.set_value("mode.modeValue", "1")
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.crazyflieA.param.set_value("mode.modeValue", "0")            
    def setmode2(self,state):
        if(state!=0):
            self.crazyflieA.param.set_value("mode.modeValue","2")
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.manual_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode1_box.checkState()==0 and
             self.panel.Checkbox_widget.manual_box.checkState()==0):
            self.crazyflieA.param.set_value("mode.modeValue", "0") 
    def setmanual(self,state):
        if(state!=0):
            self.crazyflieA.param.set_value("mode.modeValue", "3")
            self.th0.start()
            self.panel.Checkbox_widget.mode1_box.setCheckState(0)
            self.panel.Checkbox_widget.mode2_box.setCheckState(0)
        elif(self.panel.Checkbox_widget.mode2_box.checkState()==0 and
             self.panel.Checkbox_widget.mode1_box.checkState()==0):
            self.crazyflieA.param.set_value("mode.modeValue", "0")      
    def stop_motion(self):
        self.mode=1        
    def hover_motion(self):
        self.mode=1
        x=0
        while(x<10):
            x=x+1
            self.exe.hop(1)
            time.sleep(1)
    def hop_motion(self):
        self.mode=1
        self.exe.jumpStraight(1)
        time.sleep(1.5)
        self.exe.jumpStraight(0)
        time.sleep(3)
        self.exe.groundStop()
    def adaptive_motion(self):
        self.pitch=-10
        self.roll=-10
    def default_motion(self):
        self.pitch=0
        self.roll=0        

    
    
    def _connected(self,link_uri):
        """this callback is called for the Crazyflie API when a Crazyflie
        has been connected and the TOCs have been downloaded."""
        
    def _connection_failed(self, link_uri, msg):
        """Callback when connection initial connection fails (i.e no Crazyflie
        at the speficied address)"""
        print "Connection to %s failed: %s" % (link_uri, msg)

    def _connection_lost(self, link_uri, msg):
        """Callback when disconnected after a connection has been made (i.e
        Crazyflie moves out of range)"""
        print "Connection to %s lost: %s" % (link_uri, msg)

    def _disconnected(self, link_uri):
        """Callback when the Crazyflie is disconnected (called in all cases)"""
        print "Disconnected from %s" % link_uri
 
 
    
    def log_ms5611_data(self,data):
        if self.mode==0:
            self.panel.log_widget.val1Value.setText("%.2f"%data[self.logname+"."+self.val1])
            self.panel.log_widget.val2Value.setText("%.2f"%data[self.logname+"."+self.val2])
            self.panel.log_widget.val3Value.setText("%.2f"%data[self.logname+"."+self.val3])
            self.f.write("%.3f,%.3f,%.3f,%.3f,%.3f\n"
                          %(data[self.logname+"."+self.val4],
                            data[self.logname+"."+self.val5],
                            data[self.logname+"."+self.val1],
                            data[self.logname+"."+self.val2],
                            data[self.logname+"."+self.val3]))
        else:
            self.panel.log_widget.val1Value.setText("%.2f"%data[self.moni.moniClass+"."+self.moni.moniValue1])
            self.panel.log_widget.val2Value.setText("%.2f"%data[self.moni.moniClass+"."+self.moni.moniValue2])
            self.panel.log_widget.val3Value.setText("%.2f"%data[self.moni.moniClass+"."+self.moni.moniValue3])
    def log_motor_data(self,data):
        self.panel.motor_widget.motor_left_val.setValue(int("%d"%data["motor.m1"]))
        self.panel.motor_widget.motor_right_val.setValue(int("%d"%data["motor.m2"]))
        self.panel.motor_widget.motor_front_val.setValue(int("%d"%data["motor.m3"]))
        self.panel.motor_widget.motor_rear_val.setValue(int("%d"%data["motor.m4"]))           
    def disConnection(self):
        self.crazyflieA.close_link()
        self.panel.log_widget.val1Value.setText("")
        self.panel.log_widget.val2Value.setText("")
        self.panel.log_widget.val3Value.setText("")
        self.f.close()        
    def pulse_command(self):
        while 1:
            if self.mode==0:
                self.crazyflieA.commander.send_setpoint(self.roll, self.pitch, self.yawrate, self.thrust)
                time.sleep(0.1)
            else:
                self.crazyflieA.commander.send_setpoint(self.exe.roll, self.exe.pitch, self.exe.yaw, self.exe.thrust)
                time.sleep(0.1)         
    def change_thrust(self,value):
        if value==0:
            self.thrust =value
        else:
            self.thrust =value*499+10001  
    def change_roll(self,value):
        self.roll=value
    def change_pitch(self,value):
        self.pitch=value
    def change_yaw(self,value):
        self.yawrate=value
def main():
    app =QtGui.QApplication(sys.argv)
    cf = cfMain()    
    
    main_window =QtGui.QMainWindow()
    main_window.setWindowTitle("crazyflie")
    main_window.setCentralWidget(cf.panel)
    main_window.show()
    
    app.exec_()
    
if __name__=="__main__":
    main()