import PyQt4.QtCore as QtCore
import PyQt4.QtGui as QtGui
from extractConfigure import extractConfigure
class CheckBox_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.mode1_label =QtGui.QLabel("mode1")
        self.mode1_box =QtGui.QCheckBox()
        self.mode2_label =QtGui.QLabel("mode2")
        self.mode2_box =QtGui.QCheckBox();
        self.manual_label=QtGui.QLabel("manual")
        self.manual_box=QtGui.QCheckBox()
        
        layout =QtGui.QGridLayout()
        layout.addWidget(self.mode1_label,0,0)
        layout.addWidget(self.mode1_box,0,1)
        layout.addWidget(self.mode2_label,1,0)
        layout.addWidget(self.mode2_box,1,1)
        layout.addWidget(self.manual_label,2,0)
        layout.addWidget(self.manual_box,2,1)
        self.setLayout(layout)       
    
    def uncheckMode1(self):
        self.mode1_box.setCheckState(0)
    def uncheckMode2(self):
        self.mode2_box.setCheckState(0)
    def unchecmanual(self):
        self.manual_box.setCheckState(0)
        
class TableSize_Widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.setButton=QtGui.QPushButton("Set")
        self.TableE=QtGui.QLabel("Table_end")
        self.TableS=QtGui.QLabel("Table_start")
        self.TableL=QtGui.QLabel("Table_left")
        self.TableR=QtGui.QLabel("Table_right")
        self.TableS_value=QtGui.QLineEdit("")
        self.TableE_value=QtGui.QLineEdit("")
        self.TableR_value=QtGui.QLineEdit("")
        self.TableL_value=QtGui.QLineEdit("")
        
        layout=QtGui.QGridLayout()
        layout.addWidget(self.TableE,0,0)
        layout.addWidget(self.TableS,1,0)
        layout.addWidget(self.TableR,2,0)
        layout.addWidget(self.TableL,3,0)
        layout.addWidget(self.TableE_value,0,1)
        layout.addWidget(self.TableS_value,1,1)
        layout.addWidget(self.TableR_value,2,1)
        layout.addWidget(self.TableL_value,3,1)
        layout.addWidget(self.setButton,4,0)

        self.setLayout(layout)

class Thrust_set_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.groundThrust=QtGui.QLabel("groundThrust")
        self.jumpThrust=QtGui.QLabel("jumpThrust")
        self.FlyingThrust=QtGui.QLabel("FlyingThrust")
        self.jumpThrust_value=QtGui.QLineEdit("")
        self.groundThrust_value=QtGui.QLineEdit("")
        self.Flyingthrust_value=QtGui.QLineEdit("")
        self.setButton=QtGui.QPushButton("Set")
        
        layout=QtGui.QGridLayout()
        layout.addWidget(self.groundThrust,0,0)
        layout.addWidget(self.jumpThrust,1,0)
        layout.addWidget(self.FlyingThrust,2,0)
        layout.addWidget(self.groundThrust_value,0,1)
        layout.addWidget(self.jumpThrust_value,1,1)
        layout.addWidget(self.Flyingthrust_value,2,1)
        layout.addWidget(self.setButton,3,0)
        self.setLayout(layout)
        
class Speed_set_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
        
    def setup_ui(self):
        self.speed=QtGui.QLabel("hoverSpeed")
        self.speed_value=QtGui.QLineEdit("")
        self.span=QtGui.QLabel("hoverMovingSpan")
        self.span_value=QtGui.QLineEdit("")
        self.setButton=QtGui.QPushButton("Set")
        
        layout=QtGui.QGridLayout()
        layout.addWidget(self.speed,0,0)
        layout.addWidget(self.speed_value,0,1)
        layout.addWidget(self.span,1,0)
        layout.addWidget(self.span_value,1,1)
        layout.addWidget(self.setButton,2,0)
        self.setLayout(layout)
        
class TableSize_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.safety_th=QtGui.QLabel("safety_th")
        self.position_th=QtGui.QLabel("position_th")
        self.safety_th_vale=QtGui.QLineEdit("")
        self.position_th_vale=QtGui.QLineEdit("")
        self.setButton=QtGui.QPushButton("Set")
        layout=QtGui.QGridLayout()
        layout.addWidget(self.safety_th,0,0)
        layout.addWidget(self.safety_th_vale,0,1)
        layout.addWidget(self.position_th,1,0)
        layout.addWidget(self.position_th_vale,1,1)
        layout.addWidget(self.setButton,2,0)
        self.setLayout(layout)

class Connection_Button_Widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
        
    def setup_ui(self):
        self.connect_button =QtGui.QPushButton("Connect",parent=self)       
        self.disconnect_button=QtGui.QPushButton("Disconnect",parent=self)
        
        layout =QtGui.QGridLayout()
        layout.addWidget(self.connect_button,0,0)
        layout.addWidget(self.disconnect_button,0,1)
        
        self.setLayout(layout)
        
    def connect_disenable(self):
        self.connect_button.setEnabled(False)
    def connect_enable(self):
        self.connect_button.setEnabled(True)
        
class Motor_Data_Widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.motor_right =QtGui.QLabel("right")
        self.motor_right_val =QtGui.QSlider(QtCore.Qt.Vertical,self)
        self.motor_right_val.setMaximum(60000)
        self.motor_left =QtGui.QLabel("left")
        self.motor_left_val =QtGui.QSlider(QtCore.Qt.Vertical,self)
        self.motor_left_val.setMaximum(60000)
        self.motor_front =QtGui.QLabel("front")
        self.motor_front_val=QtGui.QSlider(QtCore.Qt.Vertical,self)
        self.motor_front_val.setMaximum(60000)
        self.motor_rear =QtGui.QLabel("rear")
        self.motor_rear_val=QtGui.QSlider(QtCore.Qt.Vertical,self)
        self.motor_rear_val.setMaximum(60000)
        
        layout =QtGui.QGridLayout()
        layout.addWidget(self.motor_left_val,0,0)
        layout.addWidget(self.motor_left,1,0)
        layout.addWidget(self.motor_front_val,0,1)
        layout.addWidget(self.motor_front,1,1)
        layout.addWidget(self.motor_rear_val,0,2)
        layout.addWidget(self.motor_rear,1,2)
        layout.addWidget(self.motor_right_val,0,3)
        layout.addWidget(self.motor_right,1,3)
        self.setLayout(layout)

class Thrust_Widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        
        self.pitch_name=QtGui.QLabel("pitch")
        self.pitch_value =QtGui.QLabel("0")
        self.pitch_slider =QtGui.QSlider(QtCore.Qt.Horizontal,self)
        self.pitch_slider.setMaximum(90)
        self.pitch_slider.setMinimum(-90)
        self.pitch_slider.setFocusPolicy(QtCore.Qt.NoFocus)
        
        self.roll_name=QtGui.QLabel("roll")
        self.roll_value =QtGui.QLabel("0")
        self.roll_slider =QtGui.QSlider(QtCore.Qt.Horizontal,self)
        self.roll_slider.setMaximum(90)
        self.roll_slider.setMinimum(-90)
        self.roll_slider.setFocusPolicy(QtCore.Qt.NoFocus)
        
        self.yaw_name=QtGui.QLabel("yaw")
        self.yaw_value=QtGui.QLabel("0")
        self.yaw_slider =QtGui.QSlider(QtCore.Qt.Horizontal,self)
        self.yaw_slider.setMaximum(180)
        self.yaw_slider.setMinimum(-180)
        self.yaw_slider.setFocusPolicy(QtCore.Qt.NoFocus)
        
        self.thrust_name=QtGui.QLabel("thrust")
        self.thrust_value =QtGui.QLabel("60")
        self.thrust_slider =QtGui.QSlider(QtCore.Qt.Horizontal,self)
        self.thrust_slider.setFocusPolicy(QtCore.Qt.NoFocus)
        self.thrust_slider.setValue(60)
        self.thrust_slider.setGeometry(50,10,100,30)
        layout =QtGui.QGridLayout()
        
        layout.addWidget(self.thrust_name,0,0)
        layout.addWidget(self.thrust_slider,0,1)
        layout.addWidget(self.thrust_value,0,2)
        layout.addWidget(self.roll_name,1,0)
        layout.addWidget(self.roll_slider,1,1)
        layout.addWidget(self.roll_value,1,2)
        layout.addWidget(self.pitch_name,2,0)
        layout.addWidget(self.pitch_slider,2,1)
        layout.addWidget(self.pitch_value,2,2)
        layout.addWidget(self.yaw_name,3,0)
        layout.addWidget(self.yaw_slider,3,1)
        layout.addWidget(self.yaw_value,3,2)
        self.setLayout(layout)
    
    def change_thrustValue(self,value):
            self.thrust_value.setText(str(value))
    def change_rollValue(self,value):
            self.roll_value.setText(str(value))
    def change_pitchValue(self,value):
            self.pitch_value.setText(str(value))
    def change_yawValue(self,value):
            self.yaw_value.setText(str(value))

class direction_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        
        self.stairsButton=QtGui.QPushButton("StairSweep")
        self.stopButton =QtGui.QPushButton("stop")
        self.hoverButton =QtGui.QPushButton("hover")
        self.hopButton =QtGui.QPushButton("hop")
        self.adaptiveButton =QtGui.QPushButton("adaptive")
        self.debugLabel =QtGui.QLabel("")
        
        self.stairsButton.setStyleSheet("background-color:yellow")
        self.stopButton.setStyleSheet("background-color:white;")
        self.hoverButton.setStyleSheet("background-color:green;")
        self.adaptiveButton.setStyleSheet("background-color:red;")
        self.hopButton.setStyleSheet("background-color:blue;")

        layout =QtGui.QGridLayout()
        layout.addWidget(self.stopButton,0,0)
        layout.addWidget(self.hoverButton,1,0)
        layout.addWidget(self.adaptiveButton,2,0)
        layout.addWidget(self.hopButton,3,0)
        layout.addWidget(self.stairsButton,4,0)
        self.setLayout(layout)
            


class Log_Widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.val1=QtGui.QLabel("a")
        self.val1Value=QtGui.QLineEdit("")
        self.val2=QtGui.QLabel("b")
        self.val2Value=QtGui.QLineEdit("")
        self.val3=QtGui.QLabel("c")
        self.val3Value=QtGui.QLineEdit("")
        self.val4=QtGui.QLabel("d")
        self.val4Value=QtGui.QLineEdit("")
        self.val5=QtGui.QLabel("e")
        self.val5Value=QtGui.QLineEdit("")
        self.val6=QtGui.QLabel("f")
        self.val6Value=QtGui.QLineEdit("")        
        self.val7=QtGui.QLabel("h")
        self.val7Value=QtGui.QLineEdit("")
        self.val8=QtGui.QLabel("i")
        self.val8Value=QtGui.QLineEdit("")

        layout =QtGui.QGridLayout()
        layout.addWidget(self.val1,0,0)
        layout.addWidget(self.val1Value,0,1)
        layout.addWidget(self.val2,1,0)
        layout.addWidget(self.val2Value,1,1)
        layout.addWidget(self.val3,2,0)
        layout.addWidget(self.val3Value,2,1)
        layout.addWidget(self.val4,3,0)
        layout.addWidget(self.val4Value,3,1)
        layout.addWidget(self.val5,4,0)
        layout.addWidget(self.val5Value,4,1)
        layout.addWidget(self.val6,5,0)
        layout.addWidget(self.val6Value,5,1)
        layout.addWidget(self.val7,6,0)
        layout.addWidget(self.val7Value,6,1)
        layout.addWidget(self.val8,7,0)
        layout.addWidget(self.val8Value,7,1)

        self.setLayout(layout)
 
class map_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()
    def setup_ui(self):
        self.map=QtGui.QTextEdit()
        self.mapLable=QtGui.QLabel("goal map")
        layout=QtGui.QGridLayout()
        layout.addWidget(self.map,1,0)
        layout.addWidget(self.mapLable,0,0)
        self.setLayout(layout)
        
class panel_widget(QtGui.QWidget):
    def __init__(self,parent=None):
        QtGui.QWidget.__init__(self,parent=parent)
        self.setup_ui()

    def setup_ui(self):
        self.button_widget =Connection_Button_Widget(parent=self)
        self.log_widget =Log_Widget(parent=self)
        self.thrust_widget =Thrust_Widget(parent=self)
        self.direction_widget =direction_widget(parent=self)
        self.motor_widget = Motor_Data_Widget(parent=self)
        self.tablesize_wdiget=TableSize_Widget(parent=self)
        #self.thrust_widget.setEnabled(False)
        self.Checkbox_widget =CheckBox_widget(parent=self)
        self.th_widget=TableSize_widget(parent=self)
        self.mapWidget=map_widget(parent=self)
        self.thrust_set_widget=Thrust_set_widget(parent=self)
        self.Speed_set_widget=Speed_set_widget(parent=self)
        
        
        layout =QtGui.QGridLayout()
        layout.addWidget(self.button_widget,0,0)
        layout.addWidget(self.log_widget,1,0,2,1)
        layout.addWidget(self.thrust_widget,3,0)
#        layout.addWidget(self.Checkbox_widget,3,0)
        layout.addWidget(self.direction_widget,0,1,2,1)
        layout.addWidget(self.motor_widget,2,1,3,1)
        layout.addWidget(self.tablesize_wdiget,1,2,2,2)
        layout.addWidget(self.th_widget,3,2)
        layout.addWidget(self.thrust_set_widget,0,2)
        layout.addWidget(self.Speed_set_widget,0,4)        
        layout.addWidget(self.mapWidget,1,4,2,4)

        self.setLayout(layout)
        self.setFixedSize(700,450)
        
    def setThisWidget(self,MainWindow):
        MainWindow.setCentralWidget(self)

class Main_Window(QtGui.QMainWindow):
    def __init__(self,parent=None):
        QtGui.QMainWindow.__init__(self,parent)
        self.ec=extractConfigure()
        self.panel=panel_widget()
        self.addMenubar()
        self.panel.setThisWidget(self)

        
    def addMenubar(self):
        self.file_menu=self.menuBar().addMenu('&File')
#        self.menubar=QtGui.QMenuBar(self)
#        self.menubar.setGeometry(0,0,348,24)
#        self.menubar.setObjectName("menubar")
#        self.setMenuBar(self.menubar)
    def saveFile(self):
        QtGui.QFileDialog.getSaveFileName(self,'Save Map','.')
    def getMapFile(self):
        self.ec.getMapFromFile(QtGui.QFileDialog.getOpenFileName(self, 'Open Map','.'))
        
        
    def openFile1(self):
        fn=QtGui.QFileDialog.getOpenFileName(self,'Open file','.')
        
        fp=open(fn)
        print("open!!")
        