package shooting;

import java.util.EnumMap;

public class EnumMapMonthList {
   private enum Month {
     JANUARY, FEBRUARY, MARCH, APRIL,
     MAY, JUNE, JULY, AUGUST,
     SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER;
   }
   private EnumMap<Month, Integer> monthMap;
 
   public EnumMapMonthList() {
       monthMap = new EnumMap<Month, Integer>(Month.class);
       monthMap.put(Month.JANUARY, 1);
       monthMap.put(Month.FEBRUARY, 2);
       monthMap.put(Month.MARCH, 3);
       monthMap.put(Month.APRIL, 4);
       monthMap.put(Month.MAY, 5);
       monthMap.put(Month.JUNE, 6);
       monthMap.put(Month.JULY, 7);
       monthMap.put(Month.AUGUST, 8);
       monthMap.put(Month.SEPTEMBER, 9);
       monthMap.put(Month.OCTOBER, 10);
       monthMap.put(Month.NOVEMBER, 11);
       monthMap.put(Month.DECEMBER, 12);
   }
   public void exec() {
       System.out.println("2011年");
       for (Month m : Month.values()) {
           String s = monthMap.get(m) + "月";
           switch (m) {
           case FEBRUARY:
               s = s + ":" + m + "(28日)";
               break;
           case APRIL:
           case JUNE:
           case SEPTEMBER:
           case NOVEMBER:
               s = s + ":" + m + "(30日)";
               break;
           case JANUARY:
           case MARCH:
           case MAY:
           case JULY:
           case AUGUST:
           case OCTOBER:
           case DECEMBER:
               s = s + ":" + m + "(31日)";
               break;
           }
           System.out.println(s);
       }
   }
   public static void main(String[] args) {
       EnumMapMonthList app = new EnumMapMonthList();
       app.exec();
   }
}