/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import prantl.ant.eclipse.ClassPathElement;
import prantl.ant.eclipse.ClassPathEntryBinaryElement;
import prantl.ant.eclipse.ClassPathEntryContainerElement;
import prantl.ant.eclipse.ClassPathEntryElement;
import prantl.ant.eclipse.ClassPathEntryOutputElement;
import prantl.ant.eclipse.ClassPathEntrySourceElement;
import prantl.ant.eclipse.ClassPathEntryVariableElement;
import prantl.ant.eclipse.EclipseOutput;
import prantl.ant.eclipse.EclipseTask;
import prantl.ant.eclipse.XmlWriter;

final class ClassPathGenerator {
    private EclipseTask task;

    ClassPathGenerator(EclipseTask parent) {
        this.task = parent;
    }

    private void checkClassPathEntries(ClassPathElement classPath) {
        if (this.task.getEclipse().getMode().getIndex() == 1 && ClassPathGenerator.getClassPathEntry(classPath.getVariables(), "ASPECTJRT_LIB") == null) {
            ClassPathEntryVariableElement variable = classPath.createVariable();
            variable.setPath("ASPECTJRT_LIB");
            variable.setSource("ASPECTJRT_SRC");
        }
    }

    private String cutBaseDirectory(String path, String base) {
        if (!path.startsWith(base)) {
            return path;
        }
        this.task.log("Cutting base directory \"" + base + "\" from the path \"" + path + "\".", 3);
        return path.substring(base.length() + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generate() {
        ClassPathElement classPath = this.task.getEclipse().getClassPath();
        if (classPath == null) {
            this.task.log("There was no description of a classpath found.", 1);
            return;
        }
        EclipseOutput output = this.task.getOutput();
        if (output.isClassPathUpToDate()) {
            this.task.log("The classpath definition is up-to-date.", 1);
            return;
        }
        this.task.log("Writing the classpath definition.");
        XmlWriter writer = null;
        try {
            try {
                writer = new XmlWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(output.createClassPath()), "UTF-8"));
                writer.writeXmlDeclaration("UTF-8");
                writer.openElement("classpath");
                this.checkClassPathEntries(classPath);
                this.generateContainerClassPathEntry(writer);
                this.generateSourceClassPathEntries(writer);
                Vector entries = new Vector();
                this.processVariableClassPathEntries(entries, classPath.getVariables());
                this.processLibraryClassPathEntries(entries, classPath.getLibraries());
                this.writeProcessedBinaryClassPathEntries(writer, entries);
                this.generateOutputClassPathEntry(writer);
                writer.closeElement("classpath");
            }
            catch (UnsupportedEncodingException exception) {
                throw new BuildException("Encoder to UTF-8 is not supported.", (Throwable)exception);
            }
            catch (IOException exception) {
                throw new BuildException("Writing the classpath definition failed.", (Throwable)exception);
            }
            Object var5_8 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException exception1) {
                throw new BuildException("Closing the classpath definition failed.", (Throwable)exception1);
            }
        }
        try {
            writer.close();
            return;
        }
        catch (IOException exception1) {
            throw new BuildException("Closing the classpath definition failed.", (Throwable)exception1);
        }
    }

    private void generateContainerClassPathEntry(XmlWriter writer) throws IOException {
        ClassPathEntryContainerElement container = this.task.getEclipse().getClassPath().getContainer();
        if (container == null) {
            this.task.log("No container found, a default one added.", 3);
            container = new ClassPathEntryContainerElement();
        }
        container.validate();
        String path = container.getPath();
        if (path.indexOf(47) < 0 && !path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            this.task.log("Prepending the container class name to the container path \"" + path + "\".", 3);
            path = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + path;
        }
        this.task.log("Adding container \"" + path + "\".", 3);
        this.openClassPathEntry(writer, "con", path);
        writer.closeDegeneratedElement();
    }

    private void generateOutputClassPathEntry(XmlWriter writer) throws IOException {
        ClassPathEntryOutputElement output = this.task.getEclipse().getClassPath().getOutput();
        if (output == null) {
            this.task.log("No output found, the current directory added.", 3);
            output = new ClassPathEntryOutputElement();
        }
        output.validate();
        String path = this.cutBaseDirectory(output.getPath(), this.task.getProject().getBaseDir().getAbsolutePath());
        this.task.log("Adding output into \"" + path + "\".", 3);
        this.openClassPathEntry(writer, "output", path);
        writer.closeDegeneratedElement();
    }

    private void generateSourceClassPathEntries(XmlWriter writer) throws IOException {
        Vector entries = this.task.getEclipse().getClassPath().getSources();
        if (entries.size() == 0) {
            this.task.log("No source found, the current directory added.", 3);
            entries.addElement(new ClassPathEntrySourceElement());
        }
        int i = 0;
        int size = entries.size();
        while (i != size) {
            ClassPathEntrySourceElement entry = (ClassPathEntrySourceElement)entries.get(i);
            entry.validate();
            String excluding = entry.getExcluding();
            String output = entry.getOutput();
            Path path = new Path(this.task.getProject());
            Reference reference = entry.getPathRef();
            String[] items = path.list();
            if (reference != null) {
                path.setRefid(reference);
                items = path.list();
            } else {
                String value = entry.getPath();
                if (value.length() == 0) {
                    this.task.log("Using the current directory as a default source path.", 3);
                }
                items = new String[]{value};
            }
            String baseDirectory = this.task.getProject().getBaseDir().getAbsolutePath();
            int j = 0;
            while (j != items.length) {
                String item = this.cutBaseDirectory(items[j], baseDirectory);
                this.task.log("Adding sources from \"" + item + "\".", 3);
                this.openClassPathEntry(writer, "src", item);
                if (excluding != null) {
                    writer.appendAttribute("excluding", excluding);
                }
                if (output != null) {
                    writer.appendAttribute("output", output);
                }
                writer.closeDegeneratedElement();
                ++j;
            }
            ++i;
        }
    }

    private static ClassPathEntryElement getClassPathEntry(Vector entries, String path) {
        int i = 0;
        int size = entries.size();
        while (i != size) {
            ClassPathEntryElement entry = (ClassPathEntryElement)entries.get(i);
            if (path.equals(entry.getPath())) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private static ProcessedBinaryClassPathEntry getProcessedBinaryClassPathEntry(Vector entries, String path) {
        int i = 0;
        int size = entries.size();
        while (i < size) {
            ProcessedBinaryClassPathEntry entry = (ProcessedBinaryClassPathEntry)entries.get(i);
            if (entry.path.equals(path)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private void openClassPathEntry(XmlWriter writer, String kind, String path) throws IOException {
        writer.openOpeningTag("classpathentry");
        writer.appendAttribute("kind", kind);
        writer.appendAttribute("path", path);
    }

    private void processBinaryClassPathEntries(Vector entries, String kind, Vector binaries) {
        int i = 0;
        int size = binaries.size();
        while (i != size) {
            ClassPathEntryBinaryElement entry = (ClassPathEntryBinaryElement)binaries.get(i);
            entry.validate();
            Path path = new Path(this.task.getProject());
            Reference reference = entry.getPathRef();
            if (reference != null) {
                path.setRefid(reference);
            } else {
                String value = entry.getPath();
                path.setPath(value);
            }
            this.processBinaryClassPathEntries(entries, kind, entry.getExported(), entry.getSource(), entry.getJavadoc(), path.list());
            ++i;
        }
    }

    private void processBinaryClassPathEntries(Vector entries, String kind, boolean exported, String source, String javadoc_location, String[] items) {
        String baseDirectory = this.task.getProject().getBaseDir().getAbsolutePath();
        int j = 0;
        while (j != items.length) {
            String item = this.cutBaseDirectory(items[j], baseDirectory);
            ProcessedBinaryClassPathEntry element = ClassPathGenerator.getProcessedBinaryClassPathEntry(entries, item);
            if (element == null) {
                this.task.log("Processing binary dependency \"" + item + "\" of the kind \"" + kind + "\".", 3);
                element = new ProcessedBinaryClassPathEntry();
                element.kind = kind;
                element.path = item;
                element.exported = exported;
                element.sourcepath = source;
                element.javadoc_location = javadoc_location;
                entries.addElement(element);
            } else {
                this.task.log("Updating binary dependency \"" + item + "\" of the kind \"" + kind + "\".", 3);
                element.kind = kind;
                element.path = item;
                element.exported = exported;
                element.sourcepath = source;
                element.javadoc_location = javadoc_location;
            }
            ++j;
        }
    }

    private void processLibraryClassPathEntries(Vector entries, Vector paths) {
        this.processBinaryClassPathEntries(entries, "lib", paths);
    }

    private void processVariableClassPathEntries(Vector entries, Vector paths) {
        this.processBinaryClassPathEntries(entries, "var", paths);
    }

    private void writeProcessedBinaryClassPathEntries(XmlWriter writer, Vector entries) throws IOException {
        int i = 0;
        int size = entries.size();
        while (i != size) {
            ProcessedBinaryClassPathEntry element = (ProcessedBinaryClassPathEntry)entries.get(i);
            this.task.log("Adding binary dependency \"" + element.path + "\" of the kind \"" + element.kind + "\".", 3);
            this.openClassPathEntry(writer, element.kind, element.path);
            if (element.exported) {
                writer.appendAttribute("exported", "true");
            }
            if (element.sourcepath != null) {
                writer.appendAttribute("sourcepath", element.sourcepath);
            }
            if (element.javadoc_location != null) {
                writer.closeOpeningTag();
                writer.openElement("attributes");
                writer.openOpeningTag("attribute");
                writer.appendAttribute("value", element.javadoc_location);
                writer.appendAttribute("name", "javadoc_location");
                writer.closeDegeneratedElement();
                writer.closeElement("attributes");
                writer.closeElement("classpathentry");
            } else {
                writer.closeDegeneratedElement();
            }
            ++i;
        }
    }

    static class ProcessedBinaryClassPathEntry {
        String kind;
        String path;
        boolean exported;
        String sourcepath;
        String javadoc_location;

        ProcessedBinaryClassPathEntry() {
        }
    }
}

