/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import com.cloudera.sqoop.orm.ClassWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;

public class AvroExportMapper
extends AutoProgressMapper<AvroWrapper<GenericRecord>, NullWritable, SqoopRecord, NullWritable> {
    private static final String TIMESTAMP_TYPE = "java.sql.Timestamp";
    private static final String TIME_TYPE = "java.sql.Time";
    private static final String DATE_TYPE = "java.sql.Date";
    private static final String BIG_DECIMAL_TYPE = "java.math.BigDecimal";
    public static final String AVRO_COLUMN_TYPES_MAP = "sqoop.avro.column.types.map";
    private MapWritable columnTypes;
    private SqoopRecord recordImpl;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String recordClassName = conf.get("sqoop.mapreduce.export.table.class");
        if (null == recordClassName) {
            throw new IOException("Export table class name (sqoop.mapreduce.export.table.class) is not set!");
        }
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.recordImpl = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.recordImpl) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
        this.columnTypes = (MapWritable)DefaultStringifier.load((Configuration)conf, (String)AVRO_COLUMN_TYPES_MAP, MapWritable.class);
    }

    protected void map(AvroWrapper<GenericRecord> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        context.write((Object)this.toSqoopRecord((GenericRecord)key.datum()), (Object)NullWritable.get());
    }

    private SqoopRecord toSqoopRecord(GenericRecord record) throws IOException {
        Schema avroSchema = record.getSchema();
        for (Map.Entry e : this.columnTypes.entrySet()) {
            String columnName = ((Writable)e.getKey()).toString();
            String columnType = ((Writable)e.getValue()).toString();
            String cleanedCol = ClassWriter.toIdentifier(columnName);
            Schema.Field field = this.getField(avroSchema, cleanedCol, record);
            if (field == null) {
                throw new IOException("Cannot find field " + cleanedCol + " in Avro schema " + avroSchema);
            }
            Object avroObject = record.get(field.name());
            Object fieldVal = this.fromAvro(avroObject, field.schema(), columnType);
            this.recordImpl.setField(cleanedCol, fieldVal);
        }
        return this.recordImpl;
    }

    private Schema.Field getField(Schema avroSchema, String fieldName, GenericRecord record) {
        for (Schema.Field field : avroSchema.getFields()) {
            if (!field.name().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    private Object fromAvro(Object avroObject, Schema fieldSchema, String columnType) {
        if (avroObject == null) {
            return null;
        }
        switch (fieldSchema.getType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case INT: 
            case FLOAT: 
            case DOUBLE: {
                return avroObject;
            }
            case LONG: {
                if (columnType.equals(DATE_TYPE)) {
                    return new Date((Long)avroObject);
                }
                if (columnType.equals(TIME_TYPE)) {
                    return new Time((Long)avroObject);
                }
                if (columnType.equals(TIMESTAMP_TYPE)) {
                    return new Timestamp((Long)avroObject);
                }
                return avroObject;
            }
            case BYTES: {
                ByteBuffer bb = (ByteBuffer)avroObject;
                BytesWritable bw = new BytesWritable();
                bw.set(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
                return bw;
            }
            case STRING: {
                if (columnType.equals(BIG_DECIMAL_TYPE)) {
                    return new BigDecimal(avroObject.toString());
                }
                if (columnType.equals(DATE_TYPE)) {
                    return Date.valueOf(avroObject.toString());
                }
                if (columnType.equals(TIME_TYPE)) {
                    return Time.valueOf(avroObject.toString());
                }
                if (columnType.equals(TIMESTAMP_TYPE)) {
                    return Timestamp.valueOf(avroObject.toString());
                }
                return avroObject.toString();
            }
            case ENUM: {
                return ((GenericEnumSymbol)avroObject).toString();
            }
            case UNION: {
                List types = fieldSchema.getTypes();
                if (types.size() != 2) {
                    throw new IllegalArgumentException("Only support union with null");
                }
                Schema s1 = (Schema)types.get(0);
                Schema s2 = (Schema)types.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return this.fromAvro(avroObject, s2, columnType);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return this.fromAvro(avroObject, s1, columnType);
                }
                throw new IllegalArgumentException("Only support union with null");
            }
            case FIXED: {
                return new BytesWritable(((GenericFixed)avroObject).bytes());
            }
        }
        throw new IllegalArgumentException("Cannot convert Avro type " + fieldSchema.getType());
    }
}

