/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.sqoop.mapreduce.ProgressThread;
import org.apache.sqoop.mapreduce.SqoopMapper;

public class AutoProgressMapper<KEYIN, VALIN, KEYOUT, VALOUT>
extends SqoopMapper<KEYIN, VALIN, KEYOUT, VALOUT> {
    public static final Log LOG = LogFactory.getLog((String)AutoProgressMapper.class.getName());
    public static final String MAX_PROGRESS_PERIOD_KEY = "sqoop.mapred.auto.progress.max";
    public static final String SLEEP_INTERVAL_KEY = "sqoop.mapred.auto.progress.sleep";
    public static final String REPORT_INTERVAL_KEY = "sqoop.mapred.auto.progress.report";
    public static final int DEFAULT_SLEEP_INTERVAL = 10000;
    public static final int DEFAULT_REPORT_INTERVAL = 30000;
    public static final int DEFAULT_MAX_PROGRESS = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        ProgressThread thread = new ProgressThread((TaskInputOutputContext)context, LOG);
        try {
            thread.setDaemon(true);
            thread.start();
            super.run(context);
        }
        finally {
            LOG.debug((Object)"Instructing auto-progress thread to quit.");
            thread.signalShutdown();
            try {
                LOG.debug((Object)"Waiting for progress thread shutdown...");
                thread.join();
                LOG.debug((Object)"Progress thread shutdown detected.");
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted when waiting on auto-progress thread: " + ie.toString()), (Throwable)ie);
            }
        }
    }
}

