
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.vector.complex.impl;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.hadoop.io.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;





import java.util.Map;

import org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

import com.google.common.collect.Maps;

/* This class is generated using freemarker and the MapWriters.java template */
@SuppressWarnings("unused")
public class SingleMapWriter extends AbstractFieldWriter{
  
  protected final MapVector container;
  private final Map<String, FieldWriter> fields = Maps.newHashMap();
  
  
  public SingleMapWriter(MapVector container, FieldWriter parent) {
    super(parent);
    this.container = container;
  }

  public int getValueCapacity() {
    return container.getValueCapacity();
  }

  public MaterializedField getField() {
      return container.getField();
  }

  public void checkValueCapacity(){
    inform(container.getValueCapacity() > idx());
  }

  public MapWriter map(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      int vectorCount = container.size();
      MapVector vector = container.addOrGet(name, MapVector.TYPE, MapVector.class);
      writer = new SingleMapWriter(vector, this);
      if(vectorCount != container.size()) writer.allocate();
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  public void allocate(){
    inform(container.allocateNewSafe());
    for(FieldWriter w : fields.values()){
      w.allocate();
    }
  }
  
  public void clear(){
    container.clear();
    for(FieldWriter w : fields.values()){
      w.clear();
    }
    
  }
  
  
  public ListWriter list(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      writer = new SingleListWriter(name, container, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  


  public void setValueCount(int count){
    container.getMutator().setValueCount(count);
  }

  public void setPosition(int index){
    super.setPosition(index);
    for(FieldWriter w: fields.values()){
      w.setPosition(index);  
    }
  }
  public void start(){
    // check capacity only after we have a non empty container
    if(container.size() > 0 && ok()) {
      checkValueCapacity();
    }
  }
  
  public void end(){
    //  noop
  }
  
  
  private static final MajorType TINYINT_TYPE = Types.optional(MinorType.TINYINT);
  public TinyIntWriter tinyInt(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableTinyIntVector vector = container.addOrGet(name, TINYINT_TYPE, NullableTinyIntVector.class);
      vector.allocateNewSafe();
      writer = new NullableTinyIntWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType UINT1_TYPE = Types.optional(MinorType.UINT1);
  public UInt1Writer uInt1(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableUInt1Vector vector = container.addOrGet(name, UINT1_TYPE, NullableUInt1Vector.class);
      vector.allocateNewSafe();
      writer = new NullableUInt1WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType UINT2_TYPE = Types.optional(MinorType.UINT2);
  public UInt2Writer uInt2(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableUInt2Vector vector = container.addOrGet(name, UINT2_TYPE, NullableUInt2Vector.class);
      vector.allocateNewSafe();
      writer = new NullableUInt2WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType SMALLINT_TYPE = Types.optional(MinorType.SMALLINT);
  public SmallIntWriter smallInt(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableSmallIntVector vector = container.addOrGet(name, SMALLINT_TYPE, NullableSmallIntVector.class);
      vector.allocateNewSafe();
      writer = new NullableSmallIntWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType INT_TYPE = Types.optional(MinorType.INT);
  public IntWriter integer(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableIntVector vector = container.addOrGet(name, INT_TYPE, NullableIntVector.class);
      vector.allocateNewSafe();
      writer = new NullableIntWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType UINT4_TYPE = Types.optional(MinorType.UINT4);
  public UInt4Writer uInt4(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableUInt4Vector vector = container.addOrGet(name, UINT4_TYPE, NullableUInt4Vector.class);
      vector.allocateNewSafe();
      writer = new NullableUInt4WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType FLOAT4_TYPE = Types.optional(MinorType.FLOAT4);
  public Float4Writer float4(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableFloat4Vector vector = container.addOrGet(name, FLOAT4_TYPE, NullableFloat4Vector.class);
      vector.allocateNewSafe();
      writer = new NullableFloat4WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType TIME_TYPE = Types.optional(MinorType.TIME);
  public TimeWriter time(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableTimeVector vector = container.addOrGet(name, TIME_TYPE, NullableTimeVector.class);
      vector.allocateNewSafe();
      writer = new NullableTimeWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType INTERVALYEAR_TYPE = Types.optional(MinorType.INTERVALYEAR);
  public IntervalYearWriter intervalYear(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableIntervalYearVector vector = container.addOrGet(name, INTERVALYEAR_TYPE, NullableIntervalYearVector.class);
      vector.allocateNewSafe();
      writer = new NullableIntervalYearWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL9_TYPE = Types.optional(MinorType.DECIMAL9);
  public Decimal9Writer decimal9(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal9Vector vector = container.addOrGet(name, DECIMAL9_TYPE, NullableDecimal9Vector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal9WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType BIGINT_TYPE = Types.optional(MinorType.BIGINT);
  public BigIntWriter bigInt(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableBigIntVector vector = container.addOrGet(name, BIGINT_TYPE, NullableBigIntVector.class);
      vector.allocateNewSafe();
      writer = new NullableBigIntWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType UINT8_TYPE = Types.optional(MinorType.UINT8);
  public UInt8Writer uInt8(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableUInt8Vector vector = container.addOrGet(name, UINT8_TYPE, NullableUInt8Vector.class);
      vector.allocateNewSafe();
      writer = new NullableUInt8WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType FLOAT8_TYPE = Types.optional(MinorType.FLOAT8);
  public Float8Writer float8(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableFloat8Vector vector = container.addOrGet(name, FLOAT8_TYPE, NullableFloat8Vector.class);
      vector.allocateNewSafe();
      writer = new NullableFloat8WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DATE_TYPE = Types.optional(MinorType.DATE);
  public DateWriter date(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDateVector vector = container.addOrGet(name, DATE_TYPE, NullableDateVector.class);
      vector.allocateNewSafe();
      writer = new NullableDateWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType TIMESTAMP_TYPE = Types.optional(MinorType.TIMESTAMP);
  public TimeStampWriter timeStamp(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableTimeStampVector vector = container.addOrGet(name, TIMESTAMP_TYPE, NullableTimeStampVector.class);
      vector.allocateNewSafe();
      writer = new NullableTimeStampWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL18_TYPE = Types.optional(MinorType.DECIMAL18);
  public Decimal18Writer decimal18(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal18Vector vector = container.addOrGet(name, DECIMAL18_TYPE, NullableDecimal18Vector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal18WriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType TIMESTAMPTZ_TYPE = Types.optional(MinorType.TIMESTAMPTZ);
  public TimeStampTZWriter timeStampTZ(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableTimeStampTZVector vector = container.addOrGet(name, TIMESTAMPTZ_TYPE, NullableTimeStampTZVector.class);
      vector.allocateNewSafe();
      writer = new NullableTimeStampTZWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType INTERVALDAY_TYPE = Types.optional(MinorType.INTERVALDAY);
  public IntervalDayWriter intervalDay(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableIntervalDayVector vector = container.addOrGet(name, INTERVALDAY_TYPE, NullableIntervalDayVector.class);
      vector.allocateNewSafe();
      writer = new NullableIntervalDayWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType INTERVAL_TYPE = Types.optional(MinorType.INTERVAL);
  public IntervalWriter interval(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableIntervalVector vector = container.addOrGet(name, INTERVAL_TYPE, NullableIntervalVector.class);
      vector.allocateNewSafe();
      writer = new NullableIntervalWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL28DENSE_TYPE = Types.optional(MinorType.DECIMAL28DENSE);
  public Decimal28DenseWriter decimal28Dense(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal28DenseVector vector = container.addOrGet(name, DECIMAL28DENSE_TYPE, NullableDecimal28DenseVector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal28DenseWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL38DENSE_TYPE = Types.optional(MinorType.DECIMAL38DENSE);
  public Decimal38DenseWriter decimal38Dense(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal38DenseVector vector = container.addOrGet(name, DECIMAL38DENSE_TYPE, NullableDecimal38DenseVector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal38DenseWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL38SPARSE_TYPE = Types.optional(MinorType.DECIMAL38SPARSE);
  public Decimal38SparseWriter decimal38Sparse(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal38SparseVector vector = container.addOrGet(name, DECIMAL38SPARSE_TYPE, NullableDecimal38SparseVector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal38SparseWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType DECIMAL28SPARSE_TYPE = Types.optional(MinorType.DECIMAL28SPARSE);
  public Decimal28SparseWriter decimal28Sparse(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableDecimal28SparseVector vector = container.addOrGet(name, DECIMAL28SPARSE_TYPE, NullableDecimal28SparseVector.class);
      vector.allocateNewSafe();
      writer = new NullableDecimal28SparseWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType VARBINARY_TYPE = Types.optional(MinorType.VARBINARY);
  public VarBinaryWriter varBinary(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableVarBinaryVector vector = container.addOrGet(name, VARBINARY_TYPE, NullableVarBinaryVector.class);
      vector.allocateNewSafe();
      writer = new NullableVarBinaryWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType VARCHAR_TYPE = Types.optional(MinorType.VARCHAR);
  public VarCharWriter varChar(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableVarCharVector vector = container.addOrGet(name, VARCHAR_TYPE, NullableVarCharVector.class);
      vector.allocateNewSafe();
      writer = new NullableVarCharWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType VAR16CHAR_TYPE = Types.optional(MinorType.VAR16CHAR);
  public Var16CharWriter var16Char(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableVar16CharVector vector = container.addOrGet(name, VAR16CHAR_TYPE, NullableVar16CharVector.class);
      vector.allocateNewSafe();
      writer = new NullableVar16CharWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  
  
  private static final MajorType BIT_TYPE = Types.optional(MinorType.BIT);
  public BitWriter bit(String name){
    FieldWriter writer = fields.get(name);
    if(writer == null){
      NullableBitVector vector = container.addOrGet(name, BIT_TYPE, NullableBitVector.class);
      vector.allocateNewSafe();
      writer = new NullableBitWriterImpl(vector, this);
      writer.setPosition(idx());
      fields.put(name, writer);
    }
    return writer;
  }
  
  

  

}
