
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class SumDateTypeFunctions {

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalDaySum implements DrillAggFunc{

  @Param IntervalDayHolder in;
  @Workspace IntervalDayHolder value;
  @Output IntervalDayHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalDayHolder();
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {

    value.days += in.days;
    value.milliseconds += in.milliseconds;
  }

  @Override
  public void output() {

    out.days = value.days;
    out.milliseconds = value.milliseconds;
  }

  @Override
  public void reset() {
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalDaySum implements DrillAggFunc{

  @Param NullableIntervalDayHolder in;
  @Workspace IntervalDayHolder value;
  @Output IntervalDayHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalDayHolder();
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.days += in.days;
    value.milliseconds += in.milliseconds;
    } // end of sout block
  }

  @Override
  public void output() {

    out.days = value.days;
    out.milliseconds = value.milliseconds;
  }

  @Override
  public void reset() {
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalYearSum implements DrillAggFunc{

  @Param IntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Output IntervalYearHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalYearHolder();
    value.value = 0;
  }

  @Override
  public void add() {

	    value.value += in.value;
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalYearSum implements DrillAggFunc{

  @Param NullableIntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Output IntervalYearHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalYearHolder();
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

	    value.value += in.value;
    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalSum implements DrillAggFunc{

  @Param IntervalHolder in;
  @Workspace IntervalHolder value;
  @Output IntervalHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalHolder();
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {

    value.days += in.days;
    value.months += in.months;
    value.milliseconds += in.milliseconds;
  }

  @Override
  public void output() {

    out.months = value.months;
    out.days = value.days;
    out.milliseconds = value.milliseconds;
  }

  @Override
  public void reset() {
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalSum implements DrillAggFunc{

  @Param NullableIntervalHolder in;
  @Workspace IntervalHolder value;
  @Output IntervalHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalHolder();
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.days += in.days;
    value.months += in.months;
    value.milliseconds += in.milliseconds;
    } // end of sout block
  }

  @Override
  public void output() {

    out.months = value.months;
    out.days = value.days;
    out.milliseconds = value.milliseconds;
  }

  @Override
  public void reset() {
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

}
