
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/* 
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class MinFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(MinFunctions.class);


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class BitMin implements DrillAggFunc{

  @Param BitHolder in;
  @Workspace BitHolder value;
  @Output BitHolder out;

  public void setup(RecordBatch b) {
	value = new BitHolder();
        value.value = 1;
	  
  }
  
  @Override
  public void add() {
	    value.value = Math.min(value.value, in.value);
  }

  @Override
  public void output() {   
      out.value = value.value;
  }

  @Override
  public void reset() {
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntMin implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace IntHolder value;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
	value = new IntHolder();
	    value.value = Integer.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    value.value = Math.min(value.value, in.value);
  }

  @Override
  public void output() {   
      out.value = value.value;
  }

  @Override
  public void reset() {
	    value.value = Integer.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class BigIntMin implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
	    value.value = Long.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    value.value = Math.min(value.value, in.value);
  }

  @Override
  public void output() {   
      out.value = value.value;
  }

  @Override
  public void reset() {
	    value.value = Long.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableBitMin implements DrillAggFunc{

  @Param NullableBitHolder in;
  @Workspace BitHolder value;
    @Workspace BigIntHolder nonNullCount;
  @Output NullableBitHolder out;

  public void setup(RecordBatch b) {
	value = new BitHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
        value.value = 1;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
        else {
  	        nonNullCount.value++;
	      }
	    value.value = Math.min(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntMin implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace IntHolder value;
    @Workspace BigIntHolder nonNullCount;
  @Output NullableIntHolder out;

  public void setup(RecordBatch b) {
	value = new IntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Integer.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
        else {
  	        nonNullCount.value++;
	      }
	    value.value = Math.min(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Integer.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableBigIntMin implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace BigIntHolder value;
    @Workspace BigIntHolder nonNullCount;
  @Output NullableBigIntHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Long.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
        else {
  	        nonNullCount.value++;
	      }
	    value.value = Math.min(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Long.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class Float4Min implements DrillAggFunc{

  @Param Float4Holder in;
  @Workspace Float4Holder value;
  @Output Float4Holder out;

  public void setup(RecordBatch b) {
	value = new Float4Holder();
		value.value = Float.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    value.value = Math.min(value.value, in.value);
  }

  @Override
  public void output() {   
      out.value = value.value;
  }

  @Override
  public void reset() {
		value.value = Float.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class Float8Min implements DrillAggFunc{

  @Param Float8Holder in;
  @Workspace Float8Holder value;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
	value = new Float8Holder();
		value.value = Double.MAX_VALUE;	    
	  
  }
  
  @Override
  public void add() {
	    value.value = Math.min(value.value, in.value);
  }

  @Override
  public void output() {   
      out.value = value.value;
  }

  @Override
  public void reset() {
		value.value = Double.MAX_VALUE;	    
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableFloat4Min implements DrillAggFunc{

  @Param NullableFloat4Holder in;
  @Workspace Float4Holder value;
    @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat4Holder out;

  public void setup(RecordBatch b) {
	value = new Float4Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = Float.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
        else {
  	        nonNullCount.value++;
	      }
	    value.value = Math.min(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = Float.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "min", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableFloat8Min implements DrillAggFunc{

  @Param NullableFloat8Holder in;
  @Workspace Float8Holder value;
    @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup(RecordBatch b) {
	value = new Float8Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = Double.MAX_VALUE;	    
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
        else {
  	        nonNullCount.value++;
	      }
	    value.value = Math.min(value.value, in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
      if (nonNullCount.value > 0) {
        out.value = value.value;
        out.isSet = 1;
      } else {
        out.isSet = 0;
      }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = Double.MAX_VALUE;	    
	  
  }
 
 }

}
