
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.hadoop.io.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import io.netty.buffer.ByteBuf;

@SuppressWarnings("unused")

public class DecimalCountFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(CountFunctions.class);


@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal9Count implements DrillAggFunc{

  @Param Decimal9Holder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
    value.value++;
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal9Count implements DrillAggFunc{

  @Param NullableDecimal9Holder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal18Count implements DrillAggFunc{

  @Param Decimal18Holder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
    value.value++;
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal18Count implements DrillAggFunc{

  @Param NullableDecimal18Holder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal28SparseCount implements DrillAggFunc{

  @Param Decimal28SparseHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
    value.value++;
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal28SparseCount implements DrillAggFunc{

  @Param NullableDecimal28SparseHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class Decimal38SparseCount implements DrillAggFunc{

  @Param Decimal38SparseHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
    value.value++;
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }



@FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
public static class NullableDecimal38SparseCount implements DrillAggFunc{

  @Param NullableDecimal38SparseHolder in;
  @Workspace BigIntHolder value;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  	value = new BigIntHolder();
    value.value = 0;

  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    value.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    out.value = value.value;
  }

  @Override
  public void reset() {

	  value.value = 0;

  }

 }


}
